/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.symbolic.refiner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.AbstractARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.constraints.ConstraintsCPA;
import org.sosy_lab.cpachecker.cpa.constraints.constraint.Constraint;
import org.sosy_lab.cpachecker.cpa.constraints.domain.ConstraintsSolver;
import org.sosy_lab.cpachecker.cpa.constraints.domain.ConstraintsState;
import org.sosy_lab.cpachecker.cpa.constraints.refiner.precision.ConstraintsPrecision;
import org.sosy_lab.cpachecker.cpa.constraints.refiner.precision.RefinableConstraintsPrecision;
import org.sosy_lab.cpachecker.cpa.value.ExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPA;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisConcreteErrorPathAllocator;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.ARGTreePrecisionUpdater;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.ElementTestingSymbolicEdgeInterpolator;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.ForgettingCompositeState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.SymbolicPathInterpolator;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.SymbolicStrongestPostOperator;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.SymbolicValueAnalysisFeasibilityChecker;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.ValueTransferBasedStrongestPostOperator;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.interpolant.SymbolicInterpolant;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.interpolant.SymbolicInterpolantManager;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicIdentifier;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValue;
import org.sosy_lab.cpachecker.cpa.value.symbolic.util.SymbolicIdentifierLocator;
import org.sosy_lab.cpachecker.cpa.value.symbolic.util.SymbolicValues;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.cpa.value.type.ValueToCExpressionTransformer;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.refinement.FeasibilityChecker;
import org.sosy_lab.cpachecker.util.refinement.GenericPrefixProvider;
import org.sosy_lab.cpachecker.util.refinement.GenericRefiner;
import org.sosy_lab.cpachecker.util.refinement.InterpolationTree;
import org.sosy_lab.cpachecker.util.refinement.PathExtractor;
import org.sosy_lab.cpachecker.util.refinement.PathInterpolator;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.java_smt.api.Model;

@Options(prefix="cpa.value.refinement")
public class SymbolicValueAnalysisRefiner
extends GenericRefiner<ForgettingCompositeState, SymbolicInterpolant> {
    @Option(secure=true, description="whether or not to do lazy-abstraction", name="restart", toUppercase=true)
    private GenericRefiner.RestartStrategy restartStrategy = GenericRefiner.RestartStrategy.PIVOT;
    @Option(secure=true, description="if this option is set to false, constraints are never kept")
    private boolean trackConstraints = true;
    @Option(secure=true, name="pathConstraintsFile", description="File to which path constraints should be written.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate pathConstraintsOutputFile = PathTemplate.ofFormatString((String)"Counterexample.%d.symbolic-trace.txt");
    @Option(secure=true, name="writePathConstraints", description="Whether to write symbolic trace (including path constraints) for found erexamples")
    private boolean writePathConstraints = true;
    private SymbolicStrongestPostOperator strongestPost;
    private Precision fullPrecision;
    private ValueAnalysisConcreteErrorPathAllocator errorPathAllocator;
    private final MachineModel machineModel;

    public static Refiner create(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        return AbstractARGBasedRefiner.forARGBasedRefiner(SymbolicValueAnalysisRefiner.create0(pCpa), pCpa);
    }

    public static ARGBasedRefiner create0(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        ValueAnalysisCPA valueAnalysisCpa = CPAs.retrieveCPAOrFail(pCpa, ValueAnalysisCPA.class, SymbolicValueAnalysisRefiner.class);
        ConstraintsCPA constraintsCpa = CPAs.retrieveCPAOrFail(pCpa, ConstraintsCPA.class, SymbolicValueAnalysisRefiner.class);
        Configuration config = valueAnalysisCpa.getConfiguration();
        valueAnalysisCpa.injectRefinablePrecision();
        constraintsCpa.injectRefinablePrecision(new RefinableConstraintsPrecision(config));
        LogManager logger = valueAnalysisCpa.getLogger();
        CFA cfa = valueAnalysisCpa.getCFA();
        ShutdownNotifier shutdownNotifier = valueAnalysisCpa.getShutdownNotifier();
        ConstraintsSolver solver = constraintsCpa.getSolver();
        ValueTransferBasedStrongestPostOperator strongestPostOperator = new ValueTransferBasedStrongestPostOperator(solver, logger, config, cfa);
        SymbolicValueAnalysisFeasibilityChecker feasibilityChecker = new SymbolicValueAnalysisFeasibilityChecker(strongestPostOperator, config, logger, cfa);
        GenericPrefixProvider<ForgettingCompositeState> prefixProvider = new GenericPrefixProvider<ForgettingCompositeState>(strongestPostOperator, ForgettingCompositeState.getInitialState(cfa.getMachineModel()), logger, cfa, config, ValueAnalysisCPA.class, shutdownNotifier);
        ElementTestingSymbolicEdgeInterpolator edgeInterpolator = new ElementTestingSymbolicEdgeInterpolator(feasibilityChecker, strongestPostOperator, SymbolicInterpolantManager.getInstance(), config, shutdownNotifier, cfa);
        SymbolicPathInterpolator pathInterpolator = new SymbolicPathInterpolator(edgeInterpolator, feasibilityChecker, prefixProvider, config, logger, shutdownNotifier, cfa);
        return new SymbolicValueAnalysisRefiner(cfa, feasibilityChecker, strongestPostOperator, pathInterpolator, new PathExtractor(logger, config), config, logger);
    }

    public SymbolicValueAnalysisRefiner(CFA pCfa, FeasibilityChecker<ForgettingCompositeState> pFeasibilityChecker, SymbolicStrongestPostOperator pStrongestPostOperator, PathInterpolator<SymbolicInterpolant> pInterpolator, PathExtractor pPathExtractor, Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException {
        super(pFeasibilityChecker, pInterpolator, SymbolicInterpolantManager.getInstance(), pPathExtractor, pConfig, pLogger);
        pConfig.inject((Object)this);
        this.strongestPost = pStrongestPostOperator;
        this.fullPrecision = VariableTrackingPrecision.createStaticPrecision(pConfig, pCfa.getVarClassification(), ValueAnalysisCPA.class);
        this.machineModel = pCfa.getMachineModel();
        this.errorPathAllocator = new ValueAnalysisConcreteErrorPathAllocator(pConfig, pLogger, this.machineModel);
        if (this.writePathConstraints && !pCfa.getLanguage().equals((Object)Language.C)) {
            throw new InvalidConfigurationException("At the moment, writing path constraints is only supported for C");
        }
    }

    @Override
    public CounterexampleInfo performRefinementForPath(ARGReachedSet pReached, ARGPath targetPathToUse) throws CPAException, InterruptedException {
        CounterexampleInfo info = super.performRefinementForPath(pReached, targetPathToUse);
        if (!info.isSpurious() && this.writePathConstraints && this.pathConstraintsOutputFile != null) {
            return this.getCexWithSymbolicInformation(info, this.pathConstraintsOutputFile);
        }
        return info;
    }

    private List<Pair<ForgettingCompositeState, List<CFAEdge>>> evaluate(ARGPath pTargetPath, Map<SymbolicIdentifier, Value> pIdentifierAssignment) throws CPAException, InterruptedException {
        PathIterator fullPath = pTargetPath.fullPathIterator();
        ARGState first = pTargetPath.getFirstState();
        ValueAnalysisState firstValue = (ValueAnalysisState)Preconditions.checkNotNull((Object)AbstractStates.extractStateByType(first, ValueAnalysisState.class));
        ConstraintsState firstConstraints = (ConstraintsState)Preconditions.checkNotNull((Object)AbstractStates.extractStateByType(first, ConstraintsState.class));
        ForgettingCompositeState currentState = new ForgettingCompositeState(firstValue, firstConstraints);
        ArrayDeque callstack = new ArrayDeque();
        ArrayList<Pair<ForgettingCompositeState, List<CFAEdge>>> stateSequence = new ArrayList<Pair<ForgettingCompositeState, List<CFAEdge>>>(pTargetPath.size());
        while (fullPath.hasNext()) {
            ArrayList<CFAEdge> intermediateEdges = new ArrayList<CFAEdge>();
            CFAEdge currentEdge = fullPath.getOutgoingEdge();
            intermediateEdges.add(currentEdge);
            Optional<ForgettingCompositeState> maybeNext = this.strongestPost.step(currentState, currentEdge, this.fullPrecision, callstack, pTargetPath);
            fullPath.advance();
            if (!maybeNext.isPresent()) {
                throw new CPAException("Counterexample said to be feasible but spurious at edge: " + currentEdge);
            }
            currentState = maybeNext.orElseThrow();
            if (!pIdentifierAssignment.isEmpty()) {
                ValueAnalysisState currentValueState = currentState.getValueState();
                HashSet usedIdentifiers = new HashSet();
                for (Map.Entry<MemoryLocation, ValueAnalysisState.ValueAndType> e : currentValueState.getConstants()) {
                    Value v = e.getValue().getValue();
                    if (!(v instanceof SymbolicValue)) continue;
                    usedIdentifiers.addAll(((SymbolicValue)v).accept(SymbolicIdentifierLocator.getInstance()));
                }
                ExpressionValueVisitor valueVisitor = new ExpressionValueVisitor(currentValueState, currentEdge.getSuccessor().getFunctionName(), this.machineModel, new LogManagerWithoutDuplicates(this.logger));
                for (SymbolicIdentifier i : usedIdentifiers) {
                    if (pIdentifierAssignment.containsKey(i)) {
                        currentValueState.assignConstant(i, pIdentifierAssignment.get(i), valueVisitor);
                        continue;
                    }
                    currentValueState.assignConstant(i, (Value)new NumericValue(0), valueVisitor);
                }
            }
            stateSequence.add(Pair.of(currentState, intermediateEdges));
        }
        return stateSequence;
    }

    private CounterexampleInfo getCexWithSymbolicInformation(CounterexampleInfo pCex, PathTemplate pOutputFile) throws CPAException, InterruptedException {
        ARGPath tp = pCex.getTargetPath();
        StringBuilder symbolicInfo = new StringBuilder();
        List<Pair<ForgettingCompositeState, List<CFAEdge>>> stateSequence = this.evaluate(tp, (Map<SymbolicIdentifier, Value>)ImmutableMap.of());
        ARGState first = tp.getFirstState();
        ValueAnalysisState firstValue = (ValueAnalysisState)Preconditions.checkNotNull((Object)AbstractStates.extractStateByType(first, ValueAnalysisState.class));
        ConstraintsState firstConstraints = (ConstraintsState)Preconditions.checkNotNull((Object)AbstractStates.extractStateByType(first, ConstraintsState.class));
        ForgettingCompositeState currentState = new ForgettingCompositeState(firstValue, firstConstraints);
        for (Pair<ForgettingCompositeState, List<CFAEdge>> p : stateSequence) {
            CExpressionStatement exp;
            ValueToCExpressionTransformer toCExpressionVisitor;
            ForgettingCompositeState nextState = p.getFirst();
            ValueAnalysisState nextVals = nextState.getValueState();
            ValueAnalysisState oldVals = currentState.getValueState();
            HashSet<Map.Entry<MemoryLocation, ValueAnalysisState.ValueAndType>> newAssignees = new HashSet<Map.Entry<MemoryLocation, ValueAnalysisState.ValueAndType>>(nextVals.getConstants());
            newAssignees.removeAll(oldVals.getConstants());
            ImmutableList.Builder assumptions = ImmutableList.builder();
            for (Map.Entry entry : newAssignees) {
                Iterator<CFAEdge> v = ((ValueAnalysisState.ValueAndType)entry.getValue()).getValue();
                CType t = (CType)((ValueAnalysisState.ValueAndType)entry.getValue()).getType();
                toCExpressionVisitor = new ValueToCExpressionTransformer(t);
                CExpression rhs = v.accept(toCExpressionVisitor);
                CIdExpression lhs = this.getCorrespondingIdExpression((MemoryLocation)entry.getKey(), t);
                CBinaryExpression assignment = new CBinaryExpression(FileLocation.DUMMY, t, t, lhs, rhs, CBinaryExpression.BinaryOperator.EQUALS);
                exp = new CExpressionStatement(FileLocation.DUMMY, assignment);
                assumptions.add((Object)exp);
            }
            ConstraintsState nextConstraints = nextState.getConstraintsState();
            ConstraintsState oldConstraints = currentState.getConstraintsState();
            ConstraintsState constraintsState = nextConstraints.copyOf();
            constraintsState.removeAll(oldConstraints);
            for (Constraint c : constraintsState) {
                toCExpressionVisitor = new ValueToCExpressionTransformer((CType)c.getType());
                exp = new CExpressionStatement(FileLocation.DUMMY, c.accept(toCExpressionVisitor));
                assumptions.add((Object)exp);
            }
            for (CFAEdge e : p.getSecond()) {
                symbolicInfo.append(e.toString());
                symbolicInfo.append(System.lineSeparator());
            }
            CFAEdgeWithAssumptions edgeWithAssumption = new CFAEdgeWithAssumptions(p.getSecond().get(0), (ImmutableCollection<AExpressionStatement>)assumptions.build(), "");
            symbolicInfo.append(edgeWithAssumption.prettyPrintCode(1));
            currentState = nextState;
        }
        currentState = stateSequence.get(stateSequence.size() - 1).getFirst();
        ConstraintsState finalConstraints = currentState.getConstraintsState();
        ImmutableList<Model.ValueAssignment> assignments = finalConstraints.getModel();
        HashMap<SymbolicIdentifier, Value> assignment = new HashMap<SymbolicIdentifier, Value>();
        for (Object va : assignments) {
            if (SymbolicValues.isSymbolicTerm(va.getName())) {
                SymbolicIdentifier identifier = SymbolicValues.convertTermToSymbolicIdentifier(va.getName());
                Value value = SymbolicValues.convertToValue((Model.ValueAssignment)va);
                assignment.put(identifier, value);
                continue;
            }
            this.logger.log(Level.FINE, new Object[]{"Skipping variable %s for assignment because it doesn't fit symbolic identifier encoding", va.getName()});
        }
        stateSequence = this.evaluate(tp, assignment);
        ArrayList concreteAssignmentsOnPath = new ArrayList(stateSequence.size());
        for (Pair e : stateSequence) {
            concreteAssignmentsOnPath.add(Pair.of(((ForgettingCompositeState)e.getFirst()).getValueState(), (List)e.getSecond()));
        }
        CFAPathWithAssumptions assumptionsPath = this.errorPathAllocator.allocateAssignmentsToPath(concreteAssignmentsOnPath);
        CounterexampleInfo concreteCex = CounterexampleInfo.feasiblePrecise(tp, assumptionsPath);
        concreteCex.addFurtherInformation(symbolicInfo, pOutputFile);
        return concreteCex;
    }

    private CIdExpression getCorrespondingIdExpression(MemoryLocation pMemLoc, CType pType) {
        boolean isGlobal = pMemLoc.isOnFunctionStack();
        String varName = pMemLoc.getIdentifier();
        CVariableDeclaration idDeclaration = new CVariableDeclaration(FileLocation.DUMMY, isGlobal, CStorageClass.AUTO, pType, varName, varName, varName, null);
        CIdExpression idExpression = new CIdExpression(FileLocation.DUMMY, pType, varName, idDeclaration);
        return idExpression;
    }

    @Override
    protected void refineUsingInterpolants(ARGReachedSet pReached, InterpolationTree<ForgettingCompositeState, SymbolicInterpolant> pInterpolants) throws InterruptedException {
        ImmutableSet<ARGState> roots = pInterpolants.obtainRefinementRoots(this.restartStrategy);
        for (ARGState r : roots) {
            Multimap<CFANode, MemoryLocation> valuePrecInc = pInterpolants.extractPrecisionIncrement(r);
            ConstraintsPrecision.Increment constrPrecInc = this.getConstraintsIncrement(r, pInterpolants);
            ARGTreePrecisionUpdater.updateARGTree(pReached, r, valuePrecInc, constrPrecInc);
        }
    }

    private ConstraintsPrecision.Increment getConstraintsIncrement(ARGState pRefinementRoot, InterpolationTree<ForgettingCompositeState, SymbolicInterpolant> pTree) {
        ConstraintsPrecision.Increment.Builder increment = ConstraintsPrecision.Increment.builder();
        if (this.trackConstraints) {
            ArrayDeque<ARGState> todo = new ArrayDeque<ARGState>(Collections.singleton(pTree.getPredecessor(pRefinementRoot)));
            while (!todo.isEmpty()) {
                SymbolicInterpolant itp;
                ARGState currentState = (ARGState)todo.removeFirst();
                if (!currentState.isTarget() && (itp = pTree.getInterpolantForState(currentState)) != null && !itp.isTrivial()) {
                    for (Constraint c : itp.getConstraints()) {
                        increment.locallyTracked(AbstractStates.extractLocation(currentState), c);
                    }
                }
                Collection<ARGState> successors = pTree.getSuccessors(currentState);
                todo.addAll(successors);
            }
        }
        return increment.build();
    }

    @Override
    protected void printAdditionalStatistics(PrintStream out, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        super.collectStatistics(pStatsCollection);
        if (this.strongestPost instanceof StatisticsProvider) {
            ((StatisticsProvider)((Object)this.strongestPost)).collectStatistics(pStatsCollection);
        }
    }
}

