/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.symbolic.refiner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Deque;
import java.util.Optional;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.defaults.precision.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.constraints.ConstraintsStatistics;
import org.sosy_lab.cpachecker.cpa.constraints.ConstraintsTransferRelation;
import org.sosy_lab.cpachecker.cpa.constraints.domain.ConstraintsSolver;
import org.sosy_lab.cpachecker.cpa.constraints.domain.ConstraintsState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisTransferRelation;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisStrongestPostOperator;
import org.sosy_lab.cpachecker.cpa.value.symbolic.ConstraintsStrengthenOperator;
import org.sosy_lab.cpachecker.cpa.value.symbolic.SymbolicValueAssigner;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.ForgettingCompositeState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.SymbolicStrongestPostOperator;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class ValueTransferBasedStrongestPostOperator
implements SymbolicStrongestPostOperator,
StatisticsProvider {
    private final ValueAnalysisTransferRelation valueTransfer;
    private final ValueAnalysisStrongestPostOperator valueStrongestPost;
    private final ConstraintsTransferRelation constraintsTransfer;
    private final ConstraintsStatistics constraintsStatistics;

    public ValueTransferBasedStrongestPostOperator(ConstraintsSolver pSolver, LogManager pLogger, Configuration pConfig, CFA pCfa) throws InvalidConfigurationException {
        this.valueTransfer = new ValueAnalysisTransferRelation(pLogger, pCfa, new ValueAnalysisTransferRelation.ValueTransferOptions(pConfig), new SymbolicValueAssigner(pConfig), new ConstraintsStrengthenOperator(pConfig, pLogger), null);
        this.valueStrongestPost = new ValueAnalysisStrongestPostOperator(pLogger, pConfig, pCfa);
        this.constraintsStatistics = new ConstraintsStatistics(ValueTransferBasedStrongestPostOperator.class.getSimpleName());
        this.constraintsTransfer = new ConstraintsTransferRelation(pSolver, this.constraintsStatistics, pCfa.getMachineModel(), pLogger, pConfig);
    }

    @Override
    public Optional<ForgettingCompositeState> getStrongestPost(ForgettingCompositeState pOrigin, Precision pPrecision, CFAEdge pOperation) throws CPAException, InterruptedException {
        ValueAnalysisState oldValues = pOrigin.getValueState();
        ConstraintsState oldConstraints = pOrigin.getConstraintsState();
        assert (oldValues != null && oldConstraints != null);
        Collection successors = this.valueTransfer.getAbstractSuccessorsForEdge(oldValues, pPrecision, pOperation);
        if (this.isContradiction(successors)) {
            return Optional.empty();
        }
        ValueAnalysisState valuesSuccessor = (ValueAnalysisState)Iterables.getOnlyElement(successors);
        Collection constraintsSuccessors = this.constraintsTransfer.getAbstractSuccessorsForEdge(oldConstraints, SingletonPrecision.getInstance(), pOperation);
        if (this.isContradiction(constraintsSuccessors)) {
            return Optional.empty();
        }
        ConstraintsState constraintsSuccessor = (ConstraintsState)Iterables.get(constraintsSuccessors, (int)0);
        Optional<ConstraintsState> constraintsStrengthenResult = this.strengthenConstraintsState(constraintsSuccessor, valuesSuccessor, pOperation);
        if (!constraintsStrengthenResult.isPresent()) {
            return Optional.empty();
        }
        Optional<ValueAnalysisState> valueStrengthenResult = this.strengthenValueState(valuesSuccessor, constraintsSuccessor, pPrecision, pOperation);
        if (!valueStrengthenResult.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.getNewCompositeState(valueStrengthenResult.orElseThrow(), constraintsStrengthenResult.orElseThrow()));
    }

    @Override
    public ForgettingCompositeState handleFunctionCall(ForgettingCompositeState pStateBeforeCall, CFAEdge pEdge, Deque<ForgettingCompositeState> pCallstack) {
        pCallstack.push(pStateBeforeCall);
        return pStateBeforeCall;
    }

    @Override
    public ForgettingCompositeState handleFunctionReturn(ForgettingCompositeState pNext, CFAEdge pEdge, Deque<ForgettingCompositeState> pCallstack) {
        ForgettingCompositeState callState = pCallstack.pop();
        ConstraintsState constraintsState = pNext.getConstraintsState();
        ValueAnalysisState currentValueState = pNext.getValueState();
        ValueAnalysisState callStateValueState = callState.getValueState();
        currentValueState = currentValueState.rebuildStateAfterFunctionCall(callStateValueState, (FunctionExitNode)pEdge.getPredecessor());
        return this.getNewCompositeState(currentValueState, constraintsState);
    }

    @Override
    public ForgettingCompositeState performAbstraction(ForgettingCompositeState pNext, CFANode pCurrNode, ARGPath pErrorPath, Precision pPrecision) {
        ValueAnalysisState oldValueState = pNext.getValueState();
        assert (pPrecision instanceof VariableTrackingPrecision);
        ValueAnalysisState newValueState = this.valueStrongestPost.performAbstraction(oldValueState, pCurrNode, pErrorPath, pPrecision);
        return this.getNewCompositeState(newValueState, pNext.getConstraintsState());
    }

    private Optional<ValueAnalysisState> strengthenValueState(ValueAnalysisState pValues, ConstraintsState pConstraints, Precision pPrecision, CFAEdge pOperation) throws CPATransferException {
        Collection<? extends AbstractState> strengthenResult = this.valueTransfer.strengthen(pValues, (Iterable<AbstractState>)ImmutableList.of((Object)pConstraints), pOperation, pPrecision);
        if (this.isContradiction(strengthenResult)) {
            return Optional.empty();
        }
        AbstractState onlyState = (AbstractState)Iterables.getOnlyElement(strengthenResult);
        return Optional.of((ValueAnalysisState)onlyState);
    }

    private Optional<ConstraintsState> strengthenConstraintsState(ConstraintsState pConstraintsState, ValueAnalysisState pValueState, CFAEdge pOperation) throws CPATransferException, InterruptedException {
        Collection<? extends AbstractState> successors = this.constraintsTransfer.strengthen(pConstraintsState, (Iterable<AbstractState>)ImmutableList.of((Object)pValueState), pOperation, SingletonPrecision.getInstance());
        if (this.isContradiction(successors)) {
            return Optional.empty();
        }
        AbstractState onlyState = (AbstractState)Iterables.getOnlyElement(successors);
        return Optional.of((ConstraintsState)onlyState);
    }

    private boolean isContradiction(Collection<? extends AbstractState> pAbstractStates) {
        return pAbstractStates.isEmpty();
    }

    private ForgettingCompositeState getNewCompositeState(ValueAnalysisState pNextValueState, ConstraintsState pConstraints) {
        return new ForgettingCompositeState(pNextValueState, pConstraints);
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        statsCollection.add(this.constraintsStatistics);
    }
}

