/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.delegation;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.constraints.domain.ConstraintsState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisStrongestPostOperator;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.ForgettingCompositeState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.SymbolicStrongestPostOperator;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class DelegatingStrongestPost
implements SymbolicStrongestPostOperator {
    private static final ConstraintsState INITIAL_CONSTRAINTS = new ConstraintsState();
    private final ValueAnalysisStrongestPostOperator explicitStrongestPost;

    public DelegatingStrongestPost(LogManager pLogger, Configuration pConfig, CFA pCfa) throws InvalidConfigurationException {
        this.explicitStrongestPost = new ValueAnalysisStrongestPostOperator(pLogger, pConfig, pCfa);
    }

    @Override
    public Optional<ForgettingCompositeState> getStrongestPost(ForgettingCompositeState pOrigin, Precision pPrecision, CFAEdge pOperation) throws CPAException, InterruptedException {
        Optional<ValueAnalysisState> successor = this.explicitStrongestPost.getStrongestPost(pOrigin.getValueState(), pPrecision, pOperation);
        if (!successor.isPresent()) {
            return Optional.empty();
        }
        ValueAnalysisState next = successor.orElseThrow();
        return Optional.of(new ForgettingCompositeState(next, INITIAL_CONSTRAINTS));
    }

    @Override
    public ForgettingCompositeState handleFunctionCall(ForgettingCompositeState pState, CFAEdge pEdge, Deque<ForgettingCompositeState> pCallstack) {
        Deque<ValueAnalysisState> valueCallstack = this.transformToValueStack(pCallstack);
        assert (pCallstack.size() == valueCallstack.size());
        pCallstack.push(pState);
        ValueAnalysisState result = this.explicitStrongestPost.handleFunctionCall(pState.getValueState(), pEdge, valueCallstack);
        assert (pCallstack.size() == valueCallstack.size());
        return new ForgettingCompositeState(result, INITIAL_CONSTRAINTS);
    }

    private Deque<ValueAnalysisState> transformToValueStack(Deque<ForgettingCompositeState> pCallstack) {
        ArrayDeque<ValueAnalysisState> valueCallstack = new ArrayDeque<ValueAnalysisState>(pCallstack.size());
        for (ForgettingCompositeState s : pCallstack) {
            valueCallstack.add(s.getValueState());
        }
        return valueCallstack;
    }

    @Override
    public ForgettingCompositeState handleFunctionReturn(ForgettingCompositeState pNext, CFAEdge pEdge, Deque<ForgettingCompositeState> pCallstack) {
        Deque<ValueAnalysisState> valueCallstack = this.transformToValueStack(pCallstack);
        assert (pCallstack.size() == valueCallstack.size());
        pCallstack.pop();
        ValueAnalysisState result = this.explicitStrongestPost.handleFunctionReturn(pNext.getValueState(), pEdge, valueCallstack);
        assert (pCallstack.size() == valueCallstack.size());
        return new ForgettingCompositeState(result, INITIAL_CONSTRAINTS);
    }

    @Override
    public ForgettingCompositeState performAbstraction(ForgettingCompositeState pNext, CFANode pCurrNode, ARGPath pErrorPath, Precision pPrecision) {
        ValueAnalysisState result = this.explicitStrongestPost.performAbstraction(pNext.getValueState(), pCurrNode, pErrorPath, pPrecision);
        return new ForgettingCompositeState(result, INITIAL_CONSTRAINTS);
    }
}

