/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.delegation;

import java.io.PrintStream;
import java.util.Collection;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.constraints.ConstraintsCPA;
import org.sosy_lab.cpachecker.cpa.constraints.refiner.precision.RefinableConstraintsPrecision;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPA;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.ElementTestingSymbolicEdgeInterpolator;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.ForgettingCompositeState;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.SymbolicFeasibilityChecker;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.SymbolicPathInterpolator;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.SymbolicStrongestPostOperator;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.SymbolicValueAnalysisFeasibilityChecker;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.SymbolicValueAnalysisRefiner;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.ValueTransferBasedStrongestPostOperator;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.delegation.DelegatingStrongestPost;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.interpolant.SymbolicInterpolant;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.interpolant.SymbolicInterpolantManager;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.refinement.FeasibilityChecker;
import org.sosy_lab.cpachecker.util.refinement.GenericEdgeInterpolator;
import org.sosy_lab.cpachecker.util.refinement.GenericFeasibilityChecker;
import org.sosy_lab.cpachecker.util.refinement.GenericPathInterpolator;
import org.sosy_lab.cpachecker.util.refinement.GenericPrefixProvider;
import org.sosy_lab.cpachecker.util.refinement.PathExtractor;
import org.sosy_lab.cpachecker.util.refinement.PathInterpolator;

public class SymbolicDelegatingRefiner
implements ARGBasedRefiner,
StatisticsProvider {
    private final SymbolicValueAnalysisRefiner explicitRefiner;
    private final SymbolicValueAnalysisRefiner symbolicRefiner;
    private final LogManager logger;
    private int explicitRefinements = 0;
    private int successfulExplicitRefinements = 0;
    private int symbolicRefinements = 0;
    private int successfulSymbolicRefinements = 0;
    private final Timer explicitRefinementTime = new Timer();
    private final Timer symbolicRefinementTime = new Timer();

    public static SymbolicDelegatingRefiner create(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        ValueAnalysisCPA valueAnalysisCpa = CPAs.retrieveCPAOrFail(pCpa, ValueAnalysisCPA.class, SymbolicValueAnalysisRefiner.class);
        ConstraintsCPA constraintsCpa = CPAs.retrieveCPAOrFail(pCpa, ConstraintsCPA.class, SymbolicValueAnalysisRefiner.class);
        Configuration config = valueAnalysisCpa.getConfiguration();
        valueAnalysisCpa.injectRefinablePrecision();
        constraintsCpa.injectRefinablePrecision(new RefinableConstraintsPrecision(config));
        LogManager logger = valueAnalysisCpa.getLogger();
        CFA cfa = valueAnalysisCpa.getCFA();
        ShutdownNotifier shutdownNotifier = valueAnalysisCpa.getShutdownNotifier();
        ValueTransferBasedStrongestPostOperator symbolicStrongestPost = new ValueTransferBasedStrongestPostOperator(constraintsCpa.getSolver(), logger, config, cfa);
        SymbolicValueAnalysisFeasibilityChecker feasibilityChecker = new SymbolicValueAnalysisFeasibilityChecker(symbolicStrongestPost, config, logger, cfa);
        GenericPrefixProvider<ForgettingCompositeState> symbolicPrefixProvider = new GenericPrefixProvider<ForgettingCompositeState>(symbolicStrongestPost, ForgettingCompositeState.getInitialState(cfa.getMachineModel()), logger, cfa, config, ValueAnalysisCPA.class, shutdownNotifier);
        ElementTestingSymbolicEdgeInterpolator symbolicEdgeInterpolator = new ElementTestingSymbolicEdgeInterpolator(feasibilityChecker, symbolicStrongestPost, SymbolicInterpolantManager.getInstance(), config, shutdownNotifier, cfa);
        SymbolicPathInterpolator pathInterpolator = new SymbolicPathInterpolator(symbolicEdgeInterpolator, feasibilityChecker, symbolicPrefixProvider, config, logger, shutdownNotifier, cfa);
        DelegatingStrongestPost explicitStrongestPost = new DelegatingStrongestPost(logger, config, cfa);
        GenericFeasibilityChecker<ForgettingCompositeState> explicitFeasibilityChecker = new GenericFeasibilityChecker<ForgettingCompositeState>(explicitStrongestPost, ForgettingCompositeState.getInitialState(cfa.getMachineModel()), ValueAnalysisCPA.class, logger, config, cfa);
        GenericEdgeInterpolator explicitEdgeInterpolator = new GenericEdgeInterpolator(explicitStrongestPost, explicitFeasibilityChecker, SymbolicInterpolantManager.getInstance(), ForgettingCompositeState.getInitialState(cfa.getMachineModel()), ValueAnalysisCPA.class, config, shutdownNotifier, cfa);
        GenericPrefixProvider<ForgettingCompositeState> explicitPrefixProvider = new GenericPrefixProvider<ForgettingCompositeState>(explicitStrongestPost, ForgettingCompositeState.getInitialState(cfa.getMachineModel()), logger, cfa, config, ValueAnalysisCPA.class, shutdownNotifier);
        GenericPathInterpolator<ForgettingCompositeState, SymbolicInterpolant> explicitPathInterpolator = new GenericPathInterpolator<ForgettingCompositeState, SymbolicInterpolant>(explicitEdgeInterpolator, explicitFeasibilityChecker, explicitPrefixProvider, SymbolicInterpolantManager.getInstance(), config, logger, shutdownNotifier, cfa);
        return new SymbolicDelegatingRefiner(feasibilityChecker, cfa, pathInterpolator, explicitFeasibilityChecker, symbolicStrongestPost, explicitPathInterpolator, config, logger);
    }

    private SymbolicDelegatingRefiner(SymbolicFeasibilityChecker pSymbolicFeasibilityChecker, CFA pCfa, SymbolicPathInterpolator pSymbolicInterpolator, FeasibilityChecker<ForgettingCompositeState> pExplicitFeasibilityChecker, SymbolicStrongestPostOperator pSymbolicStrongestPost, PathInterpolator<SymbolicInterpolant> pExplicitInterpolator, Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException {
        this.symbolicRefiner = new SymbolicValueAnalysisRefiner(pCfa, pSymbolicFeasibilityChecker, pSymbolicStrongestPost, pSymbolicInterpolator, new PathExtractor(pLogger, pConfig), pConfig, pLogger);
        this.explicitRefiner = new SymbolicValueAnalysisRefiner(pCfa, pExplicitFeasibilityChecker, pSymbolicStrongestPost, pExplicitInterpolator, new PathExtractor(pLogger, pConfig), pConfig, pLogger);
        this.logger = pLogger;
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        statsCollection.add(new Statistics(){

            @Override
            public void printStatistics(PrintStream out, CPAcheckerResult.Result result, UnmodifiableReachedSet reached) {
                out.println("Explicit refinements: " + SymbolicDelegatingRefiner.this.explicitRefinements);
                out.println("Successful explicit refinements: " + SymbolicDelegatingRefiner.this.successfulExplicitRefinements);
                out.println("Symbolic refinements: " + SymbolicDelegatingRefiner.this.symbolicRefinements);
                out.println("Successful symbolic refinements: " + SymbolicDelegatingRefiner.this.successfulSymbolicRefinements);
                out.println("Overall explicit refinement time: " + SymbolicDelegatingRefiner.this.explicitRefinementTime.getSumTime());
                out.println("Average explicit refinement time: " + SymbolicDelegatingRefiner.this.explicitRefinementTime.getAvgTime());
                out.println("Overall symbolic refinement time: " + SymbolicDelegatingRefiner.this.symbolicRefinementTime.getSumTime());
                out.println("Average symbolic refinement time: " + SymbolicDelegatingRefiner.this.symbolicRefinementTime.getAvgTime());
            }

            @Override
            public @Nullable String getName() {
                return SymbolicDelegatingRefiner.class.getSimpleName();
            }
        });
        this.symbolicRefiner.collectStatistics(statsCollection);
    }

    @Override
    public CounterexampleInfo performRefinementForPath(ARGReachedSet pReached, ARGPath pPath) throws CPAException, InterruptedException {
        this.logger.log(Level.FINER, new Object[]{"Trying to refine using explicit refiner only"});
        ++this.explicitRefinements;
        this.explicitRefinementTime.start();
        CounterexampleInfo cex = this.explicitRefiner.performRefinementForPath(pReached, pPath);
        this.explicitRefinementTime.stop();
        if (!cex.isSpurious()) {
            this.logger.log(Level.FINER, new Object[]{"Refinement using explicit refiner only failed"});
            this.logger.log(Level.FINER, new Object[]{"Trying to refine using symbolic refiner"});
            ++this.symbolicRefinements;
            this.symbolicRefinementTime.start();
            cex = this.symbolicRefiner.performRefinementForPath(pReached, pPath);
            this.symbolicRefinementTime.stop();
            this.logger.logf(Level.FINER, "Refinement using symbolic refiner finished with status %s", new Object[]{cex.isSpurious()});
            if (cex.isSpurious()) {
                ++this.successfulSymbolicRefinements;
            }
        } else {
            this.logger.log(Level.FINER, new Object[]{"Refinement using explicit refiner only successful"});
            ++this.successfulExplicitRefinements;
        }
        return cex;
    }
}

