/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.delegation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.constraints.constraint.Constraint;
import org.sosy_lab.cpachecker.cpa.constraints.refiner.precision.ConstraintsPrecision;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionManager;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionRefinementStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.ARGTreePrecisionUpdater;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;

class SymbolicPrecisionRefinementStrategy
extends PredicateAbstractionRefinementStrategy {
    private final FormulaManagerView formulaManager;

    public SymbolicPrecisionRefinementStrategy(Configuration config, LogManager pLogger, PredicateAbstractionManager pPredAbsMgr, Solver pSolver) throws InvalidConfigurationException {
        super(config, pLogger, pPredAbsMgr, pSolver);
        this.formulaManager = pSolver.getFormulaManager();
    }

    @Override
    public boolean performRefinement(ARGReachedSet pReached, List<ARGState> pAbstractionStatesTrace, List<BooleanFormula> pInterpolants, boolean pRepeatedCounterexample) throws CPAException, InterruptedException {
        if (pRepeatedCounterexample) {
            throw new CPAException("Refinement using predicate refinement failed.Try using cpa.value.symbolic.refiner.SymbolicValueAnalysisRefiner");
        }
        return super.performRefinement(pReached, pAbstractionStatesTrace, pInterpolants, pRepeatedCounterexample);
    }

    @Override
    protected void updateARG(PredicatePrecision newPrecision, ARGState pRefinementRoot, ARGReachedSet pReached) throws InterruptedException {
        assert (newPrecision.getFunctionPredicates().isEmpty()) : "Only local predicates allowed, but function predicate exists";
        assert (newPrecision.getGlobalPredicates().isEmpty()) : "Only local predicates allowed, but global predicate exists";
        ImmutableMap localPrec = newPrecision.getLocalPredicates().asMap();
        HashMultimap valuePrecInc = HashMultimap.create();
        ConstraintsPrecision.Increment.Builder constrPrecInc = ConstraintsPrecision.Increment.builder();
        for (Map.Entry entry : localPrec.entrySet()) {
            CFANode currNode = (CFANode)entry.getKey();
            HashSet<MemoryLocation> locations = new HashSet<MemoryLocation>();
            for (AbstractionPredicate p : (Collection)entry.getValue()) {
                for (String varName : this.formulaManager.extractVariableNames((Formula)p.getSymbolicAtom())) {
                    locations.add(MemoryLocation.parseExtendedQualifiedName(varName));
                }
            }
            valuePrecInc.putAll((Object)currNode, locations);
            constrPrecInc.locallyTracked(currNode, (Constraint)null);
        }
        ARGTreePrecisionUpdater.updateARGTree(pReached, pRefinementRoot, (Multimap<CFANode, MemoryLocation>)valuePrecInc, constrPrecInc.build());
    }
}

