/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.interpolant;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.constraints.constraint.Constraint;
import org.sosy_lab.cpachecker.cpa.constraints.domain.ConstraintsState;
import org.sosy_lab.cpachecker.cpa.constraints.util.ConstraintsInformation;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisInformation;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisInterpolant;
import org.sosy_lab.cpachecker.cpa.value.symbolic.refiner.ForgettingCompositeState;
import org.sosy_lab.cpachecker.util.refinement.Interpolant;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public final class SymbolicInterpolant
implements Interpolant<ForgettingCompositeState, SymbolicInterpolant> {
    static final SymbolicInterpolant TRUE = new SymbolicInterpolant();
    static final SymbolicInterpolant FALSE = new SymbolicInterpolant((ValueAnalysisInterpolant)null, null);
    private final ValueAnalysisInterpolant valueInterpolant;
    private final ConstraintsInformation constraintsInformation;

    private SymbolicInterpolant() {
        this.valueInterpolant = ValueAnalysisInterpolant.createInitial();
        this.constraintsInformation = ConstraintsInformation.EMPTY;
    }

    public SymbolicInterpolant(ValueAnalysisInformation pValueInfo, ConstraintsInformation pConstraints) {
        Preconditions.checkNotNull((Object)pValueInfo);
        Preconditions.checkNotNull((Object)pConstraints);
        this.valueInterpolant = new ValueAnalysisInterpolant(pValueInfo.getAssignments());
        this.constraintsInformation = pConstraints;
    }

    private SymbolicInterpolant(ValueAnalysisInterpolant pValueInterpolant, ConstraintsInformation pConstraints) {
        this.valueInterpolant = pValueInterpolant;
        this.constraintsInformation = pConstraints;
    }

    @Override
    public ForgettingCompositeState reconstructState() {
        ValueAnalysisState values = this.valueInterpolant.reconstructState();
        ConstraintsState constraints = new ConstraintsState(this.constraintsInformation.getConstraints());
        return new ForgettingCompositeState(values, constraints);
    }

    @Override
    public int getSize() {
        return this.valueInterpolant == null ? 0 : this.valueInterpolant.getSize();
    }

    public int getConstraintsSize() {
        return this.constraintsInformation.getConstraints().size();
    }

    @Override
    public Set<MemoryLocation> getMemoryLocations() {
        return this.valueInterpolant.getMemoryLocations();
    }

    public Set<Constraint> getConstraints() {
        return this.constraintsInformation.getConstraints();
    }

    @Override
    public boolean isTrue() {
        return this.equals(TRUE);
    }

    @Override
    public boolean isFalse() {
        return this.equals(FALSE);
    }

    @Override
    public SymbolicInterpolant join(SymbolicInterpolant pOther) {
        ValueAnalysisInterpolant newValueInterpolant = this.valueInterpolant.join(pOther.valueInterpolant);
        ConstraintsInformation newConstraintsInfo = this.joinConstraints(pOther.constraintsInformation);
        return new SymbolicInterpolant(newValueInterpolant, newConstraintsInfo);
    }

    private ConstraintsInformation joinConstraints(ConstraintsInformation pOtherConstraintsInfo) {
        HashSet<Constraint> allConstraints = new HashSet<Constraint>(this.constraintsInformation.getConstraints());
        allConstraints.addAll(pOtherConstraintsInfo.getConstraints());
        return new ConstraintsInformation(allConstraints);
    }

    public String toString() {
        return "Interpolant[" + this.valueInterpolant + ", " + this.constraintsInformation + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SymbolicInterpolant that = (SymbolicInterpolant)o;
        return Objects.equals(this.constraintsInformation, that.constraintsInformation) && Objects.equals(this.valueInterpolant, that.valueInterpolant);
    }

    public int hashCode() {
        return Objects.hash(this.valueInterpolant, this.constraintsInformation);
    }
}

