/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.symbolic.type;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class AddressExpression
extends SymbolicExpression {
    private static final long serialVersionUID = -1498889385306613159L;
    private final Value addressValue;
    private final Type addressType;
    private final Value offset;

    private AddressExpression(Value pAddress, Type pAddressType, Value pOffsetValue) {
        Preconditions.checkNotNull((Object)pAddress);
        Preconditions.checkNotNull((Object)pAddressType);
        Preconditions.checkNotNull((Object)pOffsetValue);
        this.addressValue = pAddress;
        this.addressType = pAddressType;
        this.offset = pOffsetValue;
    }

    public static AddressExpression of(Value pAddress, Type pAddressType, Value pOffsetValue) {
        return new AddressExpression(pAddress, pAddressType, pOffsetValue);
    }

    public static AddressExpression withZeroOffset(Value pAddress, Type pType) {
        return new AddressExpression(pAddress, pType, new NumericValue(0));
    }

    public AddressExpression copyWithNewOffset(Value pOffsetValue) {
        return new AddressExpression(this.addressValue, this.addressType, pOffsetValue);
    }

    @Override
    public String getRepresentation() {
        return this.toString();
    }

    public Value getMemoryAddress() {
        return this.addressValue;
    }

    public Value getOffset() {
        return this.offset;
    }

    @Override
    public Type getType() {
        return this.addressType;
    }

    @Override
    public SymbolicExpression copyForLocation(MemoryLocation pRepresentedLocation) {
        return null;
    }

    @Override
    public <VisitorReturnT> VisitorReturnT accept(SymbolicValueVisitor<VisitorReturnT> pVisitor) {
        return null;
    }

    @Override
    public boolean isTrivial() {
        return this.offset instanceof SymbolicExpression;
    }

    public String toString() {
        if (this.addressType != null) {
            return "Address " + this.addressValue + " at offset: " + this.offset + " | type: " + this.addressType;
        }
        return "Address " + this.addressValue + " at offset " + this.offset;
    }
}

