/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.symbolic.type;

import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicExpression;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public abstract class BinarySymbolicExpression
extends SymbolicExpression {
    private static final long serialVersionUID = -5708374107141557273L;
    private final SymbolicExpression operand1;
    private final SymbolicExpression operand2;
    private final Type calculationType;
    private Type expressionType;

    BinarySymbolicExpression(SymbolicExpression pOperand1, SymbolicExpression pOperand2, Type pExpressionType, Type pCalculationType) {
        this.operand1 = pOperand1;
        this.operand2 = pOperand2;
        this.expressionType = pExpressionType;
        this.calculationType = pCalculationType;
    }

    BinarySymbolicExpression(SymbolicExpression pOperand1, SymbolicExpression pOperand2, Type pExpressionType, Type pCalculationType, MemoryLocation pRepresentedLocation) {
        super(pRepresentedLocation);
        this.operand1 = pOperand1;
        this.operand2 = pOperand2;
        this.expressionType = pExpressionType;
        this.calculationType = pCalculationType;
    }

    @Override
    public Type getType() {
        return this.expressionType;
    }

    public Type getCalculationType() {
        return this.calculationType;
    }

    public SymbolicExpression getOperand1() {
        return this.operand1;
    }

    public SymbolicExpression getOperand2() {
        return this.operand2;
    }

    @Override
    public boolean isTrivial() {
        return this.operand1.isTrivial() && this.operand2.isTrivial();
    }

    @Override
    public final boolean equals(Object pObj) {
        if (this == pObj) {
            return true;
        }
        if (pObj == null || this.getClass() != pObj.getClass()) {
            return false;
        }
        BinarySymbolicExpression that = (BinarySymbolicExpression)pObj;
        return super.equals(that) && this.operand1.equals(that.operand1) && this.operand2.equals(that.operand2) && this.expressionType.equals(that.expressionType);
    }

    @Override
    public final int hashCode() {
        return super.hashCode() + Objects.hash(this.getClass(), this.operand1, this.operand2, this.expressionType);
    }

    @Override
    public String getRepresentation() {
        if (this.getRepresentedLocation().isPresent()) {
            return this.getRepresentedLocation().orElseThrow().toString();
        }
        return "(" + this.operand1.getRepresentation() + " " + this.getOperationString() + " " + this.operand2.getRepresentation() + ")";
    }

    public String toString() {
        return this.operand1 + " " + this.getOperationString() + " " + this.operand2;
    }

    public abstract String getOperationString();
}

