/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.symbolic.type;

import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValue;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public final class ConstantSymbolicExpression
extends SymbolicExpression {
    private static final long serialVersionUID = 8720056661933193765L;
    private final Value value;
    private final Type type;

    public ConstantSymbolicExpression(Value pValue, Type pType) {
        this.value = pValue;
        this.type = pType;
    }

    public ConstantSymbolicExpression(Value pValue, Type pType, MemoryLocation pRepresentedLocation) {
        super(pRepresentedLocation);
        this.value = pValue;
        this.type = pType;
    }

    @Override
    public SymbolicExpression copyForLocation(MemoryLocation pRepresentedLocation) {
        return new ConstantSymbolicExpression(this.value, this.type, pRepresentedLocation);
    }

    @Override
    public String getRepresentation() {
        if (this.getRepresentedLocation().isPresent()) {
            return this.getRepresentedLocation().orElseThrow().toString();
        }
        return this.toString();
    }

    @Override
    public <VisitorReturnT> VisitorReturnT accept(SymbolicValueVisitor<VisitorReturnT> pVisitor) {
        return pVisitor.visit(this);
    }

    public Value getValue() {
        return this.value;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public boolean isTrivial() {
        return !(this.value instanceof SymbolicValue);
    }

    public String toString() {
        return "SymEx[" + this.value + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstantSymbolicExpression that = (ConstantSymbolicExpression)o;
        return super.equals(o) && Objects.equals(this.type, that.type) && Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 71;
        result = this.type != null ? 31 * result + this.type.hashCode() : result;
        return result;
    }
}

