/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.symbolic.type;

import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.BinarySymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValueVisitor;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public final class ShiftRightExpression
extends BinarySymbolicExpression {
    private static final long serialVersionUID = -9068365554036095329L;
    private final ShiftType shiftType;

    ShiftRightExpression(SymbolicExpression pOperand1, SymbolicExpression pOperand2, Type pExpressionType, Type pCalculationType, ShiftType pShiftType) {
        super(pOperand1, pOperand2, pExpressionType, pCalculationType);
        this.shiftType = pShiftType;
    }

    ShiftRightExpression(ShiftType pShiftType, SymbolicExpression pOperand1, SymbolicExpression pOperand2, Type pExpressionType, Type pCalculationType, MemoryLocation pRepresentedLocation) {
        super(pOperand1, pOperand2, pExpressionType, pCalculationType, pRepresentedLocation);
        this.shiftType = pShiftType;
    }

    @Override
    public ShiftRightExpression copyForLocation(MemoryLocation pRepresentedLocation) {
        return new ShiftRightExpression(this.shiftType, this.getOperand1(), this.getOperand2(), this.getType(), this.getCalculationType(), pRepresentedLocation);
    }

    public boolean isSigned() {
        return this.shiftType == ShiftType.SIGNED;
    }

    @Override
    public <VisitorReturnT> VisitorReturnT accept(SymbolicValueVisitor<VisitorReturnT> pVisitor) {
        return pVisitor.visit(this);
    }

    @Override
    public String getOperationString() {
        if (this.isSigned()) {
            return ">>";
        }
        return ">>>";
    }

    public static enum ShiftType {
        SIGNED,
        UNSIGNED;

    }
}

