/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.symbolic.type;

import com.google.common.truth.Truth;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.AdditionExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.ConstantSymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.NegationExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.PointerExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SubtractionExpression;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;

public class SymbolicExpressionTest {
    private static final CType OP_TYPE = CNumericTypes.INT;
    private static final CType POINTER_TYPE = CNumericTypes.UNSIGNED_INT;
    private static final CType PROMOTED_OP_TYPE = CNumericTypes.INT;
    private static final ConstantSymbolicExpression CONSTANT_OP1 = new ConstantSymbolicExpression(new NumericValue(1), OP_TYPE);
    private static final ConstantSymbolicExpression CONSTANT_OP2 = new ConstantSymbolicExpression(new NumericValue(5), OP_TYPE);

    @Test
    public void testEquals_BinarySymbolicExpression() {
        AdditionExpression add1 = new AdditionExpression(CONSTANT_OP1, CONSTANT_OP2, PROMOTED_OP_TYPE, PROMOTED_OP_TYPE);
        AdditionExpression add2 = new AdditionExpression(CONSTANT_OP1, CONSTANT_OP2, PROMOTED_OP_TYPE, PROMOTED_OP_TYPE);
        SubtractionExpression sub1 = new SubtractionExpression(CONSTANT_OP1, CONSTANT_OP2, PROMOTED_OP_TYPE, PROMOTED_OP_TYPE);
        Truth.assertThat((Object)add1).isEqualTo((Object)add2);
        Truth.assertThat((Object)add1).isNotEqualTo((Object)sub1);
    }

    @Test
    public void testEquals_UnarySymbolicExpression() {
        NegationExpression neg1 = new NegationExpression(CONSTANT_OP1, POINTER_TYPE);
        NegationExpression neg2 = new NegationExpression(CONSTANT_OP1, POINTER_TYPE);
        PointerExpression ptr = new PointerExpression(CONSTANT_OP1, POINTER_TYPE);
        Truth.assertThat((Object)neg1).isEqualTo((Object)neg2);
        Truth.assertThat((Object)neg1).isNotEqualTo((Object)ptr);
    }
}

