/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.symbolic.type;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValue;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class SymbolicIdentifier
implements SymbolicValue,
Comparable<SymbolicIdentifier> {
    private static final long serialVersionUID = -3773425414056328601L;
    private final long id;
    private final @Nullable MemoryLocation representedLocation;

    public SymbolicIdentifier(long pId, MemoryLocation pRepresentedLocation) {
        this.id = pId;
        this.representedLocation = pRepresentedLocation;
    }

    @Override
    public <T> T accept(SymbolicValueVisitor<T> pVisitor) {
        return pVisitor.visit(this);
    }

    @Override
    public Optional<MemoryLocation> getRepresentedLocation() {
        return Optional.ofNullable(this.representedLocation);
    }

    @Override
    public SymbolicValue copyForLocation(MemoryLocation pLocation) {
        return new SymbolicIdentifier(this.id, pLocation);
    }

    @Override
    public String getRepresentation() {
        if (this.representedLocation != null) {
            return this.representedLocation.toString();
        }
        return this.toString();
    }

    public long getId() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hashCode(this.representedLocation) + (int)(this.id ^ this.id >>> 32);
    }

    public boolean equals(Object pOther) {
        return pOther instanceof SymbolicIdentifier && ((SymbolicIdentifier)pOther).id == this.id && Objects.equals(this.representedLocation, ((SymbolicIdentifier)pOther).representedLocation);
    }

    public String toString() {
        return "SymbolicIdentifier[" + this.id + "]";
    }

    @Override
    public boolean isNumericValue() {
        return false;
    }

    @Override
    public boolean isUnknown() {
        return false;
    }

    @Override
    public boolean isExplicitlyKnown() {
        return false;
    }

    @Override
    public NumericValue asNumericValue() {
        return null;
    }

    @Override
    public Long asLong(CType type) {
        return null;
    }

    @Override
    public int compareTo(SymbolicIdentifier o) {
        return Longs.compare((long)this.getId(), (long)o.getId());
    }

    public static class Converter {
        private static final Converter SINGLETON = new Converter();

        private Converter() {
        }

        public static Converter getInstance() {
            return SINGLETON;
        }

        public String convertToStringEncoding(SymbolicIdentifier pIdentifier) {
            Optional<MemoryLocation> representedLocation = pIdentifier.getRepresentedLocation();
            assert (representedLocation.isPresent());
            return representedLocation.orElseThrow().getExtendedQualifiedName() + "#" + pIdentifier.getId();
        }

        public SymbolicIdentifier convertToIdentifier(String pIdentifierInformation) throws IllegalArgumentException {
            String variableName = FormulaManagerView.parseName(pIdentifierInformation).getFirst();
            int idStart = variableName.indexOf("#");
            Preconditions.checkArgument((idStart >= 0 ? 1 : 0) != 0, (String)"Invalid encoding: %s", (Object)pIdentifierInformation);
            String memLocName = variableName.substring(0, idStart);
            String identifierIdOnly = variableName.substring(idStart + 1);
            if (!identifierIdOnly.matches("[0-9]+")) {
                throw new AssertionError((Object)("Unexpected encoding of symbolic identifier: " + identifierIdOnly));
            }
            long id = Long.parseLong(identifierIdOnly);
            return new SymbolicIdentifier(id, MemoryLocation.parseExtendedQualifiedName(memLocName));
        }

        public boolean isSymbolicEncoding(String pName) {
            String variableName = FormulaManagerView.parseName(pName).getFirst();
            return variableName.matches(".*(::)?.*(/.*)?#[0-9]*");
        }
    }
}

