/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.symbolic.type;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.AdditionExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.AddressExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.AddressOfExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.BinaryAndExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.BinaryNotExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.BinaryOrExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.BinaryXorExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.CastExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.ConstantSymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.DivisionExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.EqualsExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.LessThanExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.LessThanOrEqualExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.LogicalAndExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.LogicalNotExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.LogicalOrExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.ModuloExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.MultiplicationExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.NegationExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.PointerExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.ShiftLeftExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.ShiftRightExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SubtractionExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicIdentifier;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.Types;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class SymbolicValueFactory {
    private static final SymbolicValueFactory SINGLETON = new SymbolicValueFactory();
    private int idCounter = 0;

    private SymbolicValueFactory() {
    }

    public static SymbolicValueFactory getInstance() {
        return SINGLETON;
    }

    public static void reset() {
        SymbolicValueFactory.SINGLETON.idCounter = 0;
    }

    public SymbolicIdentifier newIdentifier(MemoryLocation pMemoryLocation) {
        return new SymbolicIdentifier(this.idCounter++, pMemoryLocation);
    }

    public SymbolicExpression asConstant(Value pValue, Type pType) {
        Preconditions.checkNotNull((Object)pValue);
        assert (!pValue.isUnknown());
        if (pValue instanceof SymbolicExpression) {
            return (SymbolicExpression)pValue;
        }
        return new ConstantSymbolicExpression(pValue, this.getCanonicalType(pType));
    }

    public SymbolicExpression multiply(SymbolicExpression pOperand1, SymbolicExpression pOperand2, Type pType, Type pCalculationType) {
        return new MultiplicationExpression(pOperand1, pOperand2, this.getCanonicalType(pType), this.getCanonicalType(pCalculationType));
    }

    public SymbolicExpression add(SymbolicExpression pOperand1, SymbolicExpression pOperand2, Type pType, Type pCalculationType) {
        return new AdditionExpression(pOperand1, pOperand2, this.getCanonicalType(pType), this.getCanonicalType(pCalculationType));
    }

    public SymbolicExpression minus(SymbolicExpression pOperand1, SymbolicExpression pOperand2, Type pType, Type pCalculationType) {
        Type canonicalCalcType = this.getCanonicalType(pCalculationType);
        return new SubtractionExpression(pOperand1, pOperand2, this.getCanonicalType(pType), canonicalCalcType);
    }

    public SymbolicExpression negate(SymbolicExpression pFormula, Type pType) {
        Preconditions.checkNotNull((Object)pFormula);
        if (pFormula instanceof NegationExpression) {
            return ((NegationExpression)pFormula).getOperand();
        }
        return new NegationExpression(pFormula, pType);
    }

    public SymbolicExpression divide(SymbolicExpression pOperand1, SymbolicExpression pOperand2, Type pType, Type pCalculationType) {
        return new DivisionExpression(pOperand1, pOperand2, this.getCanonicalType(pType), this.getCanonicalType(pCalculationType));
    }

    public SymbolicExpression modulo(SymbolicExpression pOperand1, SymbolicExpression pOperand2, Type pType, Type pCalculationType) {
        return new ModuloExpression(pOperand1, pOperand2, this.getCanonicalType(pType), this.getCanonicalType(pCalculationType));
    }

    public SymbolicExpression shiftLeft(SymbolicExpression pOperand1, SymbolicExpression pOperand2, Type pType, Type pCalculationType) {
        return new ShiftLeftExpression(pOperand1, pOperand2, this.getCanonicalType(pType), this.getCanonicalType(pCalculationType));
    }

    public SymbolicExpression shiftRightSigned(SymbolicExpression pOperand1, SymbolicExpression pOperand2, Type pType, Type pCalculationType) {
        return new ShiftRightExpression(pOperand1, pOperand2, this.getCanonicalType(pType), this.getCanonicalType(pCalculationType), ShiftRightExpression.ShiftType.SIGNED);
    }

    public SymbolicExpression shiftRightUnsigned(SymbolicExpression pOperand1, SymbolicExpression pOperand2, Type pType, Type pCalculationType) {
        return new ShiftRightExpression(pOperand1, pOperand2, this.getCanonicalType(pType), this.getCanonicalType(pCalculationType), ShiftRightExpression.ShiftType.UNSIGNED);
    }

    public SymbolicExpression binaryAnd(SymbolicExpression pOperand1, SymbolicExpression pOperand2, Type pType, Type pCalculationType) {
        return new BinaryAndExpression(pOperand1, pOperand2, this.getCanonicalType(pType), this.getCanonicalType(pCalculationType));
    }

    public SymbolicExpression binaryOr(SymbolicExpression pOperand1, SymbolicExpression pOperand2, Type pType, Type pCalculationType) {
        return new BinaryOrExpression(pOperand1, pOperand2, this.getCanonicalType(pType), this.getCanonicalType(pCalculationType));
    }

    public SymbolicExpression binaryXor(SymbolicExpression pOperand1, SymbolicExpression pOperand2, Type pType, Type pCalculationType) {
        return new BinaryXorExpression(pOperand1, pOperand2, this.getCanonicalType(pType), this.getCanonicalType(pCalculationType));
    }

    public EqualsExpression equal(SymbolicExpression pOperand1, SymbolicExpression pOperand2, Type pType, Type pCalculationType) {
        return new EqualsExpression(pOperand1, pOperand2, this.getCanonicalType(pType), this.getCanonicalType(pCalculationType));
    }

    public SymbolicExpression lessThan(SymbolicExpression pOperand1, SymbolicExpression pOperand2, Type pType, Type pCalculationType) {
        return new LessThanExpression(pOperand1, pOperand2, this.getCanonicalType(pType), this.getCanonicalType(pCalculationType));
    }

    public SymbolicExpression lessThanOrEqual(SymbolicExpression pOperand1, SymbolicExpression pOperand2, Type pType, Type pCalculationType) {
        return new LessThanOrEqualExpression(pOperand1, pOperand2, this.getCanonicalType(pType), this.getCanonicalType(pCalculationType));
    }

    public SymbolicExpression notEqual(SymbolicExpression pOperand1, SymbolicExpression pOperand2, Type pType, Type pCalculationType) {
        return this.logicalNot(this.equal(pOperand1, pOperand2, this.getCanonicalType(pType), this.getCanonicalType(pCalculationType)), pType);
    }

    public SymbolicExpression logicalAnd(SymbolicExpression pOperand1, SymbolicExpression pOperand2, Type pType, Type pCalculationType) {
        return new LogicalAndExpression(pOperand1, pOperand2, this.getCanonicalType(pType), this.getCanonicalType(pCalculationType));
    }

    public SymbolicExpression logicalOr(SymbolicExpression pOperand1, SymbolicExpression pOperand2, Type pType, Type pCalculationType) {
        return new LogicalOrExpression(pOperand1, pOperand2, this.getCanonicalType(pType), this.getCanonicalType(pCalculationType));
    }

    public SymbolicExpression logicalNot(SymbolicExpression pOperand, Type pType) {
        if (pOperand instanceof LogicalNotExpression) {
            return ((LogicalNotExpression)pOperand).getOperand();
        }
        return new LogicalNotExpression(pOperand, this.getCanonicalType(pType));
    }

    public SymbolicExpression binaryNot(SymbolicExpression pOperand, Type pType) {
        if (pOperand instanceof BinaryNotExpression) {
            return ((BinaryNotExpression)pOperand).getOperand();
        }
        return new BinaryNotExpression(pOperand, this.getCanonicalType(pType));
    }

    public SymbolicExpression greaterThan(SymbolicExpression pOperand1, SymbolicExpression pOperand2, Type pType, Type pCalculationType) {
        return new LessThanExpression(pOperand2, pOperand1, this.getCanonicalType(pType), this.getCanonicalType(pCalculationType));
    }

    public SymbolicExpression greaterThanOrEqual(SymbolicExpression pOperand1, SymbolicExpression pOperand2, Type pType, Type pCalculationType) {
        return new LessThanOrEqualExpression(pOperand2, pOperand1, this.getCanonicalType(pType), this.getCanonicalType(pCalculationType));
    }

    public SymbolicExpression cast(SymbolicValue pValue, Type pTargetType, Optional<MachineModel> pMachineModel) {
        Type canonicalTargetType = this.getCanonicalType(pTargetType);
        if (pValue instanceof AddressExpression) {
            return (SymbolicExpression)pValue;
        }
        if (!(pValue instanceof SymbolicExpression)) {
            return this.asConstant(pValue, canonicalTargetType);
        }
        SymbolicExpression operand = (SymbolicExpression)pValue;
        if (operand.getType().equals(canonicalTargetType)) {
            return operand;
        }
        boolean isCast = operand instanceof CastExpression;
        operand = new CastExpression(operand, canonicalTargetType);
        if (isCast) {
            operand = this.simplifyCasts((CastExpression)operand, pMachineModel);
        }
        return operand;
    }

    private SymbolicExpression simplifyCasts(CastExpression pExpression, Optional<MachineModel> pMachineModel) {
        Type typeOfBasicExpression = this.getTypeOfBasicExpression(pExpression);
        SymbolicExpression operand = pExpression.getOperand();
        if (operand instanceof CastExpression) {
            Type typeOfOuterCast = pExpression.getType();
            Type typeOfInnerCast = operand.getType();
            SymbolicExpression nextOperand = ((CastExpression)operand).getOperand();
            if (typeOfOuterCast instanceof CType && pMachineModel.isPresent()) {
                assert (typeOfInnerCast instanceof CType && typeOfBasicExpression instanceof CType);
                if (Types.canHoldAllValues(typeOfInnerCast, typeOfBasicExpression, pMachineModel.orElseThrow())) {
                    return this.cast(nextOperand, typeOfOuterCast, pMachineModel);
                }
            } else if (typeOfOuterCast instanceof JType) {
                assert (typeOfInnerCast instanceof JType && typeOfBasicExpression instanceof JType);
                if (Types.canHoldAllValues((JType)typeOfInnerCast, (JType)typeOfBasicExpression)) {
                    return this.cast(nextOperand, typeOfOuterCast, pMachineModel);
                }
            }
        }
        return pExpression;
    }

    private Type getTypeOfBasicExpression(SymbolicExpression pExpression) {
        if (pExpression instanceof CastExpression) {
            return this.getTypeOfBasicExpression(((CastExpression)pExpression).getOperand());
        }
        return pExpression.getType();
    }

    public PointerExpression pointer(SymbolicExpression pOperand, Type pType) {
        Preconditions.checkNotNull((Object)pOperand);
        return new PointerExpression(pOperand, this.getCanonicalType(pType));
    }

    public SymbolicExpression addressOf(SymbolicExpression pOperand, Type pType) {
        Preconditions.checkNotNull((Object)pOperand);
        if (pOperand instanceof PointerExpression) {
            return ((PointerExpression)pOperand).getOperand();
        }
        return new AddressOfExpression(pOperand, this.getCanonicalType(pType));
    }

    private Type getCanonicalType(Type pType) {
        if (pType instanceof CType) {
            return ((CType)pType).getCanonicalType();
        }
        return pType;
    }
}

