/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.symbolic.type;

import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicExpression;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public abstract class UnarySymbolicExpression
extends SymbolicExpression {
    private static final long serialVersionUID = -2727356523115713518L;
    private final SymbolicExpression operand;
    private final Type type;

    UnarySymbolicExpression(SymbolicExpression pOperand, Type pType) {
        this.operand = pOperand;
        this.type = pType;
    }

    UnarySymbolicExpression(SymbolicExpression pOperand, Type pType, MemoryLocation pRepresentedLocation) {
        super(pRepresentedLocation);
        this.operand = pOperand;
        this.type = pType;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public SymbolicExpression getOperand() {
        return this.operand;
    }

    @Override
    public boolean isTrivial() {
        return this.operand.isTrivial();
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnarySymbolicExpression that = (UnarySymbolicExpression)o;
        return super.equals(that) && this.operand.equals(that.operand) && this.type.equals(that.type);
    }

    @Override
    public final int hashCode() {
        return super.hashCode() + Objects.hash(this.getClass(), this.operand, this.type);
    }

    @Override
    public String getRepresentation() {
        if (this.getRepresentedLocation().isPresent()) {
            return this.getRepresentedLocation().orElseThrow().toString();
        }
        return this.getOperationString() + this.operand.getRepresentation();
    }

    public String toString() {
        return this.getOperationString() + "(" + this.operand + ")";
    }

    public abstract String getOperationString();
}

