/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.symbolic.util;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.AdditionExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.AddressOfExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.BinaryAndExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.BinaryNotExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.BinaryOrExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.BinarySymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.BinaryXorExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.CastExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.ConstantSymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.DivisionExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.EqualsExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.LessThanExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.LessThanOrEqualExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.LogicalAndExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.LogicalNotExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.LogicalOrExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.ModuloExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.MultiplicationExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.NegationExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.PointerExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.ShiftLeftExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.ShiftRightExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SubtractionExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicIdentifier;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValue;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.UnarySymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.type.Value;

public class SymbolicIdentifierLocator
implements SymbolicValueVisitor<Set<SymbolicIdentifier>> {
    private static final SymbolicIdentifierLocator SINGLETON = new SymbolicIdentifierLocator();

    private SymbolicIdentifierLocator() {
    }

    public static SymbolicIdentifierLocator getInstance() {
        return SINGLETON;
    }

    @Override
    public Set<SymbolicIdentifier> visit(SymbolicIdentifier pValue) {
        return ImmutableSet.of((Object)pValue);
    }

    @Override
    public Set<SymbolicIdentifier> visit(ConstantSymbolicExpression pExpression) {
        Value containedValue = pExpression.getValue();
        if (containedValue instanceof SymbolicValue) {
            return ((SymbolicValue)containedValue).accept(this);
        }
        return ImmutableSet.of();
    }

    private Set<SymbolicIdentifier> handleBinaryExpression(BinarySymbolicExpression pExpression) {
        Set<SymbolicIdentifier> identifiersOnLeft = pExpression.getOperand1().accept(this);
        Set<SymbolicIdentifier> identifiersOnRight = pExpression.getOperand2().accept(this);
        HashSet<SymbolicIdentifier> identifiersInBoth = new HashSet<SymbolicIdentifier>(identifiersOnLeft);
        identifiersInBoth.addAll(identifiersOnRight);
        return ImmutableSet.copyOf(identifiersInBoth);
    }

    private Set<SymbolicIdentifier> handleUnaryExpression(UnarySymbolicExpression pExpression) {
        return pExpression.getOperand().accept(this);
    }

    @Override
    public Set<SymbolicIdentifier> visit(AdditionExpression pExpression) {
        return this.handleBinaryExpression(pExpression);
    }

    @Override
    public Set<SymbolicIdentifier> visit(SubtractionExpression pExpression) {
        return this.handleBinaryExpression(pExpression);
    }

    @Override
    public Set<SymbolicIdentifier> visit(MultiplicationExpression pExpression) {
        return this.handleBinaryExpression(pExpression);
    }

    @Override
    public Set<SymbolicIdentifier> visit(DivisionExpression pExpression) {
        return this.handleBinaryExpression(pExpression);
    }

    @Override
    public Set<SymbolicIdentifier> visit(ModuloExpression pExpression) {
        return this.handleBinaryExpression(pExpression);
    }

    @Override
    public Set<SymbolicIdentifier> visit(BinaryAndExpression pExpression) {
        return this.handleBinaryExpression(pExpression);
    }

    @Override
    public Set<SymbolicIdentifier> visit(BinaryNotExpression pExpression) {
        return this.handleUnaryExpression(pExpression);
    }

    @Override
    public Set<SymbolicIdentifier> visit(BinaryOrExpression pExpression) {
        return this.handleBinaryExpression(pExpression);
    }

    @Override
    public Set<SymbolicIdentifier> visit(BinaryXorExpression pExpression) {
        return this.handleBinaryExpression(pExpression);
    }

    @Override
    public Set<SymbolicIdentifier> visit(ShiftRightExpression pExpression) {
        return this.handleBinaryExpression(pExpression);
    }

    @Override
    public Set<SymbolicIdentifier> visit(ShiftLeftExpression pExpression) {
        return this.handleBinaryExpression(pExpression);
    }

    @Override
    public Set<SymbolicIdentifier> visit(LogicalNotExpression pExpression) {
        return this.handleUnaryExpression(pExpression);
    }

    @Override
    public Set<SymbolicIdentifier> visit(LessThanOrEqualExpression pExpression) {
        return this.handleBinaryExpression(pExpression);
    }

    @Override
    public Set<SymbolicIdentifier> visit(LessThanExpression pExpression) {
        return this.handleBinaryExpression(pExpression);
    }

    @Override
    public Set<SymbolicIdentifier> visit(EqualsExpression pExpression) {
        return this.handleBinaryExpression(pExpression);
    }

    @Override
    public Set<SymbolicIdentifier> visit(LogicalOrExpression pExpression) {
        return this.handleBinaryExpression(pExpression);
    }

    @Override
    public Set<SymbolicIdentifier> visit(LogicalAndExpression pExpression) {
        return this.handleBinaryExpression(pExpression);
    }

    @Override
    public Set<SymbolicIdentifier> visit(CastExpression pExpression) {
        return this.handleUnaryExpression(pExpression);
    }

    @Override
    public Set<SymbolicIdentifier> visit(PointerExpression pExpression) {
        return this.handleUnaryExpression(pExpression);
    }

    @Override
    public Set<SymbolicIdentifier> visit(AddressOfExpression pExpression) {
        return this.handleUnaryExpression(pExpression);
    }

    @Override
    public Set<SymbolicIdentifier> visit(NegationExpression pExpression) {
        return this.handleUnaryExpression(pExpression);
    }
}

