/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.symbolic.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.BinarySymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.ConstantSymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicIdentifier;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValue;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.UnarySymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.util.SymbolicIdentifierLocator;
import org.sosy_lab.cpachecker.cpa.value.type.BooleanValue;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.java_smt.api.Model;

public class SymbolicValues {
    private static final SymbolicIdentifierLocator identifierLocator = SymbolicIdentifierLocator.getInstance();

    public static boolean representSameCCodeExpression(SymbolicValue pValue1, SymbolicValue pValue2) {
        if (!pValue1.getClass().equals(pValue2.getClass())) {
            Optional<MemoryLocation> val1RepLoc = pValue1.getRepresentedLocation();
            Optional<MemoryLocation> val2RepLoc = pValue2.getRepresentedLocation();
            return (val1RepLoc.isPresent() || val2RepLoc.isPresent()) && val1RepLoc.equals(val2RepLoc);
        }
        Optional<MemoryLocation> maybeRepLocVal1 = pValue1.getRepresentedLocation();
        Optional<MemoryLocation> maybeRepLocVal2 = pValue2.getRepresentedLocation();
        if (maybeRepLocVal1.isPresent() || maybeRepLocVal2.isPresent()) {
            return maybeRepLocVal1.equals(maybeRepLocVal2);
        }
        assert (maybeRepLocVal1.equals(maybeRepLocVal2));
        if (pValue1 instanceof SymbolicIdentifier || pValue1 instanceof ConstantSymbolicExpression) {
            assert (pValue2 instanceof SymbolicIdentifier || pValue2 instanceof ConstantSymbolicExpression);
            return maybeRepLocVal1.equals(maybeRepLocVal2);
        }
        if (pValue1 instanceof UnarySymbolicExpression) {
            assert (pValue2 instanceof UnarySymbolicExpression);
            SymbolicExpression val1Op = ((UnarySymbolicExpression)pValue1).getOperand();
            SymbolicExpression val2Op = ((UnarySymbolicExpression)pValue2).getOperand();
            return SymbolicValues.representSameCCodeExpression(val1Op, val2Op);
        }
        if (pValue1 instanceof BinarySymbolicExpression) {
            assert (pValue2 instanceof BinarySymbolicExpression);
            SymbolicExpression val1Op1 = ((BinarySymbolicExpression)pValue1).getOperand1();
            SymbolicExpression val1Op2 = ((BinarySymbolicExpression)pValue1).getOperand2();
            SymbolicExpression val2Op1 = ((BinarySymbolicExpression)pValue2).getOperand1();
            SymbolicExpression val2Op2 = ((BinarySymbolicExpression)pValue2).getOperand2();
            return SymbolicValues.representSameCCodeExpression(val1Op1, val2Op1) && SymbolicValues.representSameCCodeExpression(val1Op2, val2Op2);
        }
        throw new AssertionError((Object)("Unhandled symbolic value type " + pValue1.getClass()));
    }

    public static boolean representSameSymbolicMeaning(SymbolicValue pValue1, SymbolicValue pValue2) {
        if (!pValue1.getClass().equals(pValue2.getClass())) {
            return false;
        }
        if (pValue1 instanceof SymbolicIdentifier) {
            assert (pValue2 instanceof SymbolicIdentifier);
            return ((SymbolicIdentifier)pValue1).getId() == ((SymbolicIdentifier)pValue2).getId();
        }
        if (pValue1 instanceof ConstantSymbolicExpression) {
            assert (pValue2 instanceof ConstantSymbolicExpression);
            Value innerVal1 = ((ConstantSymbolicExpression)pValue1).getValue();
            Value innerVal2 = ((ConstantSymbolicExpression)pValue2).getValue();
            if (innerVal1 instanceof SymbolicValue && innerVal2 instanceof SymbolicValue) {
                return SymbolicValues.representSameSymbolicMeaning((SymbolicValue)innerVal1, (SymbolicValue)innerVal2);
            }
            return innerVal1.equals(innerVal2);
        }
        if (pValue1 instanceof UnarySymbolicExpression) {
            assert (pValue2 instanceof UnarySymbolicExpression);
            SymbolicExpression val1Op = ((UnarySymbolicExpression)pValue1).getOperand();
            SymbolicExpression val2Op = ((UnarySymbolicExpression)pValue2).getOperand();
            return SymbolicValues.representSameSymbolicMeaning(val1Op, val2Op);
        }
        if (pValue1 instanceof BinarySymbolicExpression) {
            assert (pValue2 instanceof BinarySymbolicExpression);
            SymbolicExpression val1Op1 = ((BinarySymbolicExpression)pValue1).getOperand1();
            SymbolicExpression val1Op2 = ((BinarySymbolicExpression)pValue1).getOperand2();
            SymbolicExpression val2Op1 = ((BinarySymbolicExpression)pValue2).getOperand1();
            SymbolicExpression val2Op2 = ((BinarySymbolicExpression)pValue2).getOperand2();
            return SymbolicValues.representSameSymbolicMeaning(val1Op1, val2Op1) && SymbolicValues.representSameSymbolicMeaning(val1Op2, val2Op2);
        }
        throw new AssertionError((Object)("Unhandled symbolic value type " + pValue1.getClass()));
    }

    public static Collection<SymbolicIdentifier> getContainedSymbolicIdentifiers(SymbolicValue pValue) {
        return pValue.accept(identifierLocator);
    }

    public static Collection<SymbolicIdentifier> getContainedSymbolicIdentifiers(Collection<? extends SymbolicValue> pValues) {
        HashSet<SymbolicIdentifier> ret = new HashSet<SymbolicIdentifier>();
        for (SymbolicValue symbolicValue : pValues) {
            ret.addAll(SymbolicValues.getContainedSymbolicIdentifiers(symbolicValue));
        }
        return ret;
    }

    public static boolean isSymbolicTerm(String pTerm) {
        return SymbolicIdentifier.Converter.getInstance().isSymbolicEncoding(pTerm);
    }

    public static SymbolicIdentifier convertTermToSymbolicIdentifier(String pTerm) throws IllegalArgumentException {
        return SymbolicIdentifier.Converter.getInstance().convertToIdentifier(pTerm);
    }

    public static Value convertToValue(Model.ValueAssignment assignment) {
        Object value = assignment.getValue();
        if (value instanceof Number) {
            return new NumericValue((Number)value);
        }
        if (value instanceof Boolean) {
            return BooleanValue.valueOf((Boolean)value);
        }
        throw new AssertionError((Object)("Unexpected value " + value));
    }
}

