/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.symbolic.util;

import com.google.common.truth.Truth;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicExpression;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicIdentifier;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValueFactory;
import org.sosy_lab.cpachecker.cpa.value.symbolic.util.SymbolicValues;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class SymbolicValuesTest {
    private final MemoryLocation memLoc1 = MemoryLocation.forIdentifier("a");
    private final MemoryLocation memLoc2 = MemoryLocation.forIdentifier("b");
    private final SymbolicValueFactory factory = SymbolicValueFactory.getInstance();
    private final Type defType = CNumericTypes.INT;
    private final SymbolicIdentifier id1 = this.factory.newIdentifier(this.memLoc1);
    private final SymbolicIdentifier id2 = this.factory.newIdentifier(this.memLoc2);
    private final SymbolicExpression idExp1 = this.factory.asConstant(this.id1, this.defType);
    private final SymbolicExpression idExp2 = this.factory.asConstant(this.id2, this.defType);
    private final NumericValue num1 = new NumericValue(5);
    private final SymbolicExpression numExp1 = this.factory.asConstant(this.num1, this.defType);

    @Test
    public void testRepresentSameCCodeExpression_diffValueSameLocation() {
        SymbolicExpression locLessExp1 = this.factory.add(this.idExp1, this.idExp2, this.defType, this.defType);
        SymbolicExpression locLessExp2 = this.factory.add(this.idExp1, this.numExp1, this.defType, this.defType);
        SymbolicExpression exp1 = locLessExp1.copyForLocation(this.memLoc1);
        SymbolicExpression exp2 = locLessExp1.copyForLocation(this.memLoc2);
        SymbolicExpression exp3 = locLessExp2.copyForLocation(this.memLoc2);
        SymbolicExpression constr1 = this.factory.lessThan(exp1, exp3, this.defType, this.defType);
        SymbolicExpression constr2 = this.factory.lessThan(exp1, exp2, this.defType, this.defType);
        Truth.assertThat((Boolean)SymbolicValues.representSameCCodeExpression(exp1, exp1)).isTrue();
        Truth.assertThat((Boolean)SymbolicValues.representSameCCodeExpression(constr1, constr2)).isTrue();
        Truth.assertThat((Boolean)SymbolicValues.representSameCCodeExpression(exp1, exp2)).isFalse();
    }

    @Test
    public void testRepresentSameCCodeExpression_constraintAndItsNegation() {
        SymbolicExpression expWithLocation1 = this.idExp1.copyForLocation(this.memLoc1);
        SymbolicExpression expWithLocation2 = this.idExp2.copyForLocation(this.memLoc2);
        SymbolicExpression constraint = this.factory.add(expWithLocation1, this.numExp1, this.defType, this.defType);
        constraint = this.factory.lessThan(constraint, expWithLocation2, this.defType, this.defType);
        SymbolicExpression negation = this.factory.negate(constraint, this.defType);
        Truth.assertThat((Boolean)SymbolicValues.representSameCCodeExpression(constraint, negation)).isFalse();
    }
}

