/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.type;

import java.util.Optional;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.cpa.value.type.ValueVisitor;

public class BooleanValue
implements Value {
    private static final long serialVersionUID = -35132790150256304L;
    private static final BooleanValue TRUE_VALUE = new BooleanValue(true);
    private static final BooleanValue FALSE_VALUE = new BooleanValue(false);
    private final boolean value;

    private BooleanValue(boolean value) {
        this.value = value;
    }

    public static BooleanValue valueOf(boolean value) {
        if (value) {
            return TRUE_VALUE;
        }
        return FALSE_VALUE;
    }

    public static Optional<BooleanValue> valueOf(Value pValue) {
        if (pValue.isUnknown()) {
            return Optional.empty();
        }
        if (pValue.isNumericValue()) {
            return BooleanValue.valueOf((NumericValue)pValue);
        }
        if (pValue instanceof BooleanValue) {
            return Optional.of((BooleanValue)pValue);
        }
        return Optional.empty();
    }

    private static Optional<BooleanValue> valueOf(NumericValue pValue) {
        if (pValue.equals(new NumericValue(0L))) {
            return Optional.of(BooleanValue.valueOf(false));
        }
        if (pValue.equals(new NumericValue(1L))) {
            return Optional.of(BooleanValue.valueOf(true));
        }
        return Optional.empty();
    }

    public boolean isTrue() {
        return this.value;
    }

    public BooleanValue negate() {
        return this.value ? FALSE_VALUE : TRUE_VALUE;
    }

    @Override
    public boolean isNumericValue() {
        return false;
    }

    @Override
    public boolean isUnknown() {
        return false;
    }

    @Override
    public boolean isExplicitlyKnown() {
        return true;
    }

    @Override
    public NumericValue asNumericValue() {
        if (this.value) {
            return new NumericValue(1L);
        }
        return new NumericValue(0L);
    }

    @Override
    public Long asLong(CType pType) {
        throw new AssertionError((Object)"This method is not implemented");
    }

    @Override
    public <T> T accept(ValueVisitor<T> pVisitor) {
        return pVisitor.visit(this);
    }

    public boolean equals(Object other) {
        if (other instanceof BooleanValue) {
            return ((BooleanValue)other).value == this.value;
        }
        return false;
    }

    public int hashCode() {
        return this.value ? 1 : 0;
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

