/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.type;

import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.cpa.value.type.ValueVisitor;

public class EnumConstantValue
implements Value {
    private static final long serialVersionUID = 2745087444102463717L;
    private final String fullyQualifiedName;

    public EnumConstantValue(String pFullyQualifiedName) {
        this.fullyQualifiedName = pFullyQualifiedName;
    }

    public String getName() {
        return this.fullyQualifiedName;
    }

    @Override
    public boolean isNumericValue() {
        return false;
    }

    @Override
    public boolean isUnknown() {
        return false;
    }

    @Override
    public boolean isExplicitlyKnown() {
        return true;
    }

    @Override
    public NumericValue asNumericValue() {
        throw new AssertionError((Object)"Enum constant cannot be represented as NumericValue");
    }

    @Override
    public Long asLong(CType pType) {
        return null;
    }

    @Override
    public <T> T accept(ValueVisitor<T> pVisitor) {
        return pVisitor.visit(this);
    }

    public boolean equals(Object other) {
        if (other instanceof EnumConstantValue) {
            EnumConstantValue concreteOther = (EnumConstantValue)other;
            return concreteOther.fullyQualifiedName.equals(this.fullyQualifiedName);
        }
        return false;
    }

    public int hashCode() {
        return this.fullyQualifiedName.hashCode();
    }

    public String toString() {
        return this.fullyQualifiedName;
    }
}

