/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.type;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.cpa.value.type.ValueVisitor;

public class NumericValue
implements Value,
Serializable {
    private static final long serialVersionUID = -3829943575180448170L;
    private Number number;

    public NumericValue(Number pNumber) {
        this.number = pNumber;
    }

    public Number getNumber() {
        return this.number;
    }

    public long longValue() {
        return this.number.longValue();
    }

    public float floatValue() {
        return this.number.floatValue();
    }

    public double doubleValue() {
        return this.number.doubleValue();
    }

    public BigDecimal bigDecimalValue() {
        if (this.number instanceof Double || this.number instanceof Float) {
            return BigDecimal.valueOf(this.number.doubleValue());
        }
        if (this.number instanceof Rational) {
            Rational rat = (Rational)this.number;
            return new BigDecimal(rat.getNum()).divide(new BigDecimal(rat.getDen()), 100, RoundingMode.HALF_UP);
        }
        return new BigDecimal(this.number.toString());
    }

    public BigInteger bigInteger() {
        if (this.number instanceof BigInteger) {
            return (BigInteger)this.number;
        }
        if (this.number instanceof Double || this.number instanceof Float) {
            long x = (long)this.number.doubleValue();
            return BigInteger.valueOf(x);
        }
        if (this.number instanceof BigDecimal) {
            return ((BigDecimal)this.number).toBigInteger();
        }
        if (this.number instanceof Rational) {
            return new NumericValue(this.number).bigDecimalValue().toBigInteger();
        }
        return new BigInteger(this.number.toString());
    }

    public String toString() {
        return "NumericValue [number=" + this.number + "]";
    }

    public boolean equals(Object other) {
        if (other instanceof NumericValue) {
            return this.getNumber().equals(((NumericValue)other).getNumber());
        }
        return false;
    }

    @Override
    public boolean isNumericValue() {
        return true;
    }

    public NumericValue negate() {
        BigDecimal bd;
        Number numberToNegate = this.getNumber();
        if (numberToNegate instanceof Float) {
            if (numberToNegate.equals(Float.valueOf(Float.POSITIVE_INFINITY))) {
                return new NumericValue(Float.valueOf(Float.NEGATIVE_INFINITY));
            }
            if (numberToNegate.equals(Float.valueOf(Float.NEGATIVE_INFINITY))) {
                return new NumericValue(Float.valueOf(Float.POSITIVE_INFINITY));
            }
            if (numberToNegate.equals(Float.valueOf(Float.NaN))) {
                return new NumericValue(NegativeNaN.VALUE);
            }
        } else if (numberToNegate instanceof Double) {
            if (numberToNegate.equals(Double.POSITIVE_INFINITY)) {
                return new NumericValue(Double.NEGATIVE_INFINITY);
            }
            if (numberToNegate.equals(Double.NEGATIVE_INFINITY)) {
                return new NumericValue(Double.POSITIVE_INFINITY);
            }
            if (numberToNegate.equals(Double.NaN)) {
                return new NumericValue(NegativeNaN.VALUE);
            }
        } else {
            if (numberToNegate instanceof Rational) {
                return new NumericValue((Number)((Rational)numberToNegate).negate());
            }
            if (NegativeNaN.VALUE.equals(numberToNegate)) {
                return new NumericValue(Double.NaN);
            }
        }
        if (numberToNegate instanceof BigDecimal && (bd = (BigDecimal)numberToNegate).signum() == 0) {
            return new NumericValue(-bd.doubleValue());
        }
        return new NumericValue(this.bigDecimalValue().negate());
    }

    @Override
    public NumericValue asNumericValue() {
        return this;
    }

    @Override
    public @Nullable Long asLong(CType type) {
        Preconditions.checkNotNull((Object)type);
        type = type.getCanonicalType();
        if (!(type instanceof CSimpleType)) {
            return null;
        }
        if (((CSimpleType)type).getType() == CBasicType.INT) {
            return this.longValue();
        }
        return null;
    }

    @Override
    public <T> T accept(ValueVisitor<T> pVisitor) {
        return pVisitor.visit(this);
    }

    @Override
    public boolean isUnknown() {
        return false;
    }

    @Override
    public boolean isExplicitlyKnown() {
        return true;
    }

    public int hashCode() {
        return this.number.hashCode();
    }

    public static class NegativeNaN
    extends Number {
        private static final long serialVersionUID = 1L;
        public static final Number VALUE = new NegativeNaN();

        private NegativeNaN() {
        }

        @Override
        public double doubleValue() {
            return Double.NaN;
        }

        @Override
        public float floatValue() {
            return Float.NaN;
        }

        @Override
        public int intValue() {
            return 0;
        }

        @Override
        public long longValue() {
            return 0L;
        }

        public String toString() {
            return "-NaN";
        }

        public boolean equals(Object pObj) {
            return pObj == this || pObj instanceof NegativeNaN;
        }

        public int hashCode() {
            return -1;
        }
    }
}

