/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.type;

import com.google.common.truth.Truth;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.junit.Test;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;

public class NumericValueTest {
    @Test
    public void longValue_conversionFromPositiveLong() {
        NumericValue val = new NumericValue(5L);
        long result = val.longValue();
        Truth.assertThat((Long)result).isEqualTo((Object)5L);
    }

    @Test
    public void longValue_conversionFromDouble() {
        NumericValue val = new NumericValue(5.3);
        long result = val.longValue();
        Truth.assertThat((Long)result).isEqualTo((Object)5L);
    }

    @Test
    public void longValue_conversionFromFloat() {
        NumericValue val = new NumericValue(Float.valueOf(5.3f));
        long result = val.longValue();
        Truth.assertThat((Long)result).isEqualTo((Object)5L);
    }

    @Test
    public void longValue_conversionFromRationalWithDecimals() {
        Rational input = Rational.of((BigInteger)BigInteger.ONE, (BigInteger)BigInteger.TWO);
        NumericValue val = new NumericValue((Number)input);
        long result = val.longValue();
        Truth.assertThat((Long)result).isEqualTo((Object)0L);
    }

    @Test
    public void longValue_conversionFromRationalWithoutDecimals() {
        Rational input = Rational.of((BigInteger)BigInteger.TEN, (BigInteger)BigInteger.TWO);
        NumericValue val = new NumericValue((Number)input);
        long result = val.longValue();
        Truth.assertThat((Long)result).isEqualTo((Object)5L);
    }

    @Test
    public void longValue_conversionFromInteger() {
        NumericValue val = new NumericValue(10);
        long result = val.longValue();
        Truth.assertThat((Long)result).isEqualTo((Object)10L);
    }

    @Test
    public void bigDecimalValue_conversionFromPositiveLong() {
        NumericValue val = new NumericValue(5L);
        BigDecimal result = val.bigDecimalValue();
        Truth.assertThat((BigDecimal)result).isEqualToIgnoringScale(5L);
    }

    @Test
    public void bigDecimalValue_conversionFromDouble() {
        NumericValue val = new NumericValue(5.3);
        BigDecimal result = val.bigDecimalValue();
        Truth.assertThat((BigDecimal)result).isEqualToIgnoringScale(BigDecimal.valueOf(5.3));
    }

    @Test
    public void bigDecimalValue_conversionFromFloat() {
        NumericValue val = new NumericValue(Float.valueOf(5.3f));
        BigDecimal result = val.bigDecimalValue();
        Truth.assertThat((BigDecimal)result).isEqualToIgnoringScale(BigDecimal.valueOf(5.3f));
    }

    @Test
    public void bigDecimalValue_conversionFromRationalWithDecimals() {
        Rational input = Rational.of((BigInteger)BigInteger.ONE, (BigInteger)BigInteger.TWO);
        NumericValue val = new NumericValue((Number)input);
        BigDecimal result = val.bigDecimalValue();
        Truth.assertThat((BigDecimal)result).isEqualToIgnoringScale(BigDecimal.valueOf(0.5));
    }

    @Test
    public void bigDecimalValue_conversionFromRationalWithInfiniteDecimals() {
        Rational input = Rational.of((BigInteger)BigInteger.ONE, (BigInteger)BigInteger.valueOf(3L));
        NumericValue val = new NumericValue((Number)input);
        BigDecimal result = val.bigDecimalValue();
        BigDecimal expected = BigDecimal.ONE.divide(BigDecimal.valueOf(3L), 100, RoundingMode.HALF_UP);
        Truth.assertThat((BigDecimal)result).isEqualToIgnoringScale(expected);
    }

    @Test
    public void bigDecimalValue_conversionFromRationalWithoutDecimals() {
        Rational input = Rational.of((BigInteger)BigInteger.TEN, (BigInteger)BigInteger.TWO);
        NumericValue val = new NumericValue((Number)input);
        BigDecimal result = val.bigDecimalValue();
        Truth.assertThat((BigDecimal)result).isEqualToIgnoringScale(5L);
    }

    @Test
    public void bigDecimalValue_conversionFromInteger() {
        NumericValue val = new NumericValue(10);
        BigDecimal result = val.bigDecimalValue();
        Truth.assertThat((BigDecimal)result).isEqualToIgnoringScale(10L);
    }

    @Test
    public void bigInteger_conversionFromPositiveLong() {
        NumericValue val = new NumericValue(5L);
        BigInteger result = val.bigInteger();
        Truth.assertThat((Comparable)result).isEqualTo((Object)BigInteger.valueOf(5L));
    }

    @Test
    public void bigInteger_conversionFromDouble() {
        NumericValue val = new NumericValue(5.3);
        BigInteger result = val.bigInteger();
        Truth.assertThat((Comparable)result).isEqualTo((Object)BigInteger.valueOf(5L));
    }

    @Test
    public void bigInteger_conversionFromFloat() {
        NumericValue val = new NumericValue(Float.valueOf(5.3f));
        BigInteger result = val.bigInteger();
        Truth.assertThat((Comparable)result).isEqualTo((Object)BigInteger.valueOf(5L));
    }

    @Test
    public void bigInteger_conversionFromRationalWithDecimals() {
        Rational input = Rational.of((BigInteger)BigInteger.ONE, (BigInteger)BigInteger.TWO);
        NumericValue val = new NumericValue((Number)input);
        BigInteger result = val.bigInteger();
        Truth.assertThat((Comparable)result).isEqualTo((Object)BigInteger.valueOf(0L));
    }

    @Test
    public void bigInteger_conversionFromRationalWithoutDecimals() {
        Rational input = Rational.of((BigInteger)BigInteger.TEN, (BigInteger)BigInteger.TWO);
        NumericValue val = new NumericValue((Number)input);
        BigInteger result = val.bigInteger();
        Truth.assertThat((Comparable)result).isEqualTo((Object)BigInteger.valueOf(5L));
    }

    @Test
    public void bigInteger_conversionFromInteger() {
        NumericValue val = new NumericValue(10);
        BigInteger result = val.bigInteger();
        Truth.assertThat((Comparable)result).isEqualTo((Object)BigInteger.TEN);
    }

    @Test
    public void doubleValue_conversionFromPositiveLong() {
        NumericValue val = new NumericValue(5L);
        double result = val.doubleValue();
        Truth.assertThat((Double)result).isEqualTo((Object)5);
    }

    @Test
    public void doubleValue_conversionFromDouble() {
        NumericValue val = new NumericValue(5.3);
        double result = val.doubleValue();
        Truth.assertThat((Double)result).isEqualTo((Object)5.3);
    }

    @Test
    public void doubleValue_conversionFromFloat() {
        NumericValue val = new NumericValue(Float.valueOf(5.5f));
        double result = val.doubleValue();
        Truth.assertThat((Double)result).isEqualTo((Object)5.5);
    }

    @Test
    public void doubleValue_conversionFromRationalWithDecimals() {
        Rational input = Rational.of((BigInteger)BigInteger.ONE, (BigInteger)BigInteger.TWO);
        NumericValue val = new NumericValue((Number)input);
        double result = val.doubleValue();
        Truth.assertThat((Double)result).isEqualTo((Object)0.5);
    }

    @Test
    public void doubleValue_conversionFromRationalWithoutDecimals() {
        Rational input = Rational.of((BigInteger)BigInteger.TEN, (BigInteger)BigInteger.TWO);
        NumericValue val = new NumericValue((Number)input);
        double result = val.doubleValue();
        Truth.assertThat((Double)result).isEqualTo((Object)5);
    }

    @Test
    public void doubleValue_conversionFromInteger() {
        NumericValue val = new NumericValue(10);
        double result = val.doubleValue();
        Truth.assertThat((Double)result).isEqualTo((Object)10.0);
    }
}

