/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.type;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.ValueVisitor;

public interface Value
extends Serializable {
    public boolean isNumericValue();

    public boolean isUnknown();

    public boolean isExplicitlyKnown();

    public @Nullable NumericValue asNumericValue();

    public @Nullable Long asLong(CType var1);

    public <T> T accept(ValueVisitor<T> var1);

    public static final class UnknownValue
    implements Value,
    Serializable {
        private static final long serialVersionUID = -300842115868319184L;
        private static final UnknownValue instance = new UnknownValue();

        public String toString() {
            return "UNKNOWN";
        }

        public static UnknownValue getInstance() {
            return instance;
        }

        @Override
        public boolean isNumericValue() {
            return false;
        }

        @Override
        public @Nullable NumericValue asNumericValue() {
            return null;
        }

        @Override
        public @Nullable Long asLong(CType type) {
            Preconditions.checkNotNull((Object)type);
            return null;
        }

        @Override
        public <T> T accept(ValueVisitor<T> pVisitor) {
            return pVisitor.visit(this);
        }

        @Override
        public boolean isUnknown() {
            return true;
        }

        @Override
        public boolean isExplicitlyKnown() {
            return false;
        }

        Object readResolve() {
            return instance;
        }
    }
}

