/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.constraints.constraint.SymbolicExpressionToCExpressionTransformer;
import org.sosy_lab.cpachecker.cpa.value.symbolic.type.SymbolicValue;
import org.sosy_lab.cpachecker.cpa.value.type.ArrayValue;
import org.sosy_lab.cpachecker.cpa.value.type.BooleanValue;
import org.sosy_lab.cpachecker.cpa.value.type.EnumConstantValue;
import org.sosy_lab.cpachecker.cpa.value.type.FunctionValue;
import org.sosy_lab.cpachecker.cpa.value.type.NullValue;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.cpa.value.type.ValueVisitor;

public class ValueToCExpressionTransformer
implements ValueVisitor<CExpression> {
    private final SymbolicExpressionToCExpressionTransformer symbolicTransformer = new SymbolicExpressionToCExpressionTransformer();
    private CType type;

    public ValueToCExpressionTransformer(CType pTypeOfValue) {
        this.type = pTypeOfValue;
    }

    @Override
    public CExpression visit(EnumConstantValue pValue) {
        throw new UnsupportedOperationException(EnumConstantValue.class.getSimpleName() + " is a Java value");
    }

    @Override
    public CExpression visit(SymbolicValue pValue) {
        return pValue.accept(this.symbolicTransformer);
    }

    @Override
    public CExpression visit(Value.UnknownValue pValue) {
        throw new UnsupportedOperationException("Unknown values can't be transformed to CExpressions");
    }

    @Override
    public CExpression visit(ArrayValue pValue) {
        throw new UnsupportedOperationException(ArrayValue.class.getSimpleName() + " is a Java value");
    }

    @Override
    public CExpression visit(BooleanValue pValue) {
        BigInteger asInt = pValue.isTrue() ? BigInteger.ONE : BigInteger.ZERO;
        return new CIntegerLiteralExpression(FileLocation.DUMMY, this.type, asInt);
    }

    @Override
    public CExpression visit(FunctionValue pValue) {
        throw new UnsupportedOperationException("Function values can't be transformed back to CExpressions correctly, at the moment");
    }

    @Override
    public CExpression visit(NumericValue pValue) {
        if (this.type instanceof CSimpleType) {
            switch (((CSimpleType)this.type).getType()) {
                case FLOAT: 
                case DOUBLE: {
                    return this.visitFloatingValue(pValue, (CSimpleType)this.type);
                }
            }
        }
        return new CIntegerLiteralExpression(FileLocation.DUMMY, this.type, BigInteger.valueOf(pValue.longValue()));
    }

    private CExpression visitFloatingValue(NumericValue pValue, CSimpleType pType) {
        boolean isNan;
        boolean isNegative;
        boolean isInfinite;
        switch (pType.getType()) {
            case FLOAT: {
                float val = pValue.floatValue();
                isInfinite = Float.isInfinite(val);
                isNegative = val < 0.0f;
                isNan = Float.isNaN(val);
                break;
            }
            case DOUBLE: {
                double val = pValue.doubleValue();
                isInfinite = Double.isInfinite(val);
                isNegative = val < 0.0;
                isNan = Double.isNaN(val);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled type: " + pType));
            }
        }
        assert (!isInfinite || !isNan);
        if (isInfinite) {
            if (isNegative) {
                return CFloatLiteralExpression.forNegativeInfinity(FileLocation.DUMMY, pType);
            }
            return CFloatLiteralExpression.forPositiveInfinity(FileLocation.DUMMY, pType);
        }
        if (isNan) {
            return this.createNanExpression(pType);
        }
        return new CFloatLiteralExpression(FileLocation.DUMMY, pType, pValue.bigDecimalValue());
    }

    private CExpression createNanExpression(CSimpleType pType) {
        CFloatLiteralExpression zero = new CFloatLiteralExpression(FileLocation.DUMMY, pType, BigDecimal.ZERO);
        return new CBinaryExpression(FileLocation.DUMMY, pType, pType, zero, zero, CBinaryExpression.BinaryOperator.DIVIDE);
    }

    @Override
    public CExpression visit(NullValue pValue) {
        throw new UnsupportedOperationException(NullValue.class.getSimpleName() + " is a Java value");
    }
}

