/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.exceptions;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sosy_lab.common.annotations.SuppressForbidden;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class CompoundException
extends CPAException {
    private static final long serialVersionUID = -8880889342586540115L;
    private final List<CPAException> exceptions;

    public CompoundException(List<CPAException> pExceptions) {
        super(CompoundException.getMessage(pExceptions));
        this.exceptions = Collections.unmodifiableList(pExceptions);
    }

    public List<CPAException> getExceptions() {
        return this.exceptions;
    }

    @SuppressForbidden(value="result of Collectors.toList() is only read, needs to support null")
    private static String getMessage(List<CPAException> pExceptions) {
        Preconditions.checkArgument((pExceptions.size() > 1 ? 1 : 0) != 0, (Object)"Use a CompoundException only if there actually are multiple exceptions.");
        List messages = pExceptions.stream().map(Throwable::getMessage).distinct().collect(Collectors.toList());
        if (messages.size() == 1) {
            return (String)messages.get(0);
        }
        return "Several exceptions occured during the analysis:\n -> " + Joiner.on((String)"\n -> ").join(messages);
    }
}

