/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.exceptions;

import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;

public class ParserException
extends Exception {
    private static final long serialVersionUID = 2377475523222364935L;
    private final Language language;

    protected ParserException(String msg, Language pLanguage) {
        super(msg);
        this.language = pLanguage;
    }

    protected ParserException(Throwable cause, Language pLanguage) {
        super(cause.getMessage(), cause);
        this.language = pLanguage;
    }

    protected ParserException(String msg, Throwable cause, Language pLanguage) {
        super(msg + ": " + cause.getMessage(), cause);
        this.language = pLanguage;
    }

    protected ParserException(String msg, CFAEdge edge, Language pLanguage) {
        super(UnrecognizedCodeException.createMessage(msg, null, edge, null));
        this.language = pLanguage;
    }

    public Language getLanguage() {
        return this.language;
    }
}

