/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.exceptions;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class RefinementFailedException
extends CPAException {
    private static final long serialVersionUID = 2353178323706458175L;
    private @Nullable ARGPath path;
    private final Reason reason;

    public RefinementFailedException(Reason r, @Nullable ARGPath p) {
        super(RefinementFailedException.getMessage(r, null));
        this.reason = r;
        this.path = p;
    }

    public RefinementFailedException(Reason r, @Nullable ARGPath p, Throwable t) {
        super(RefinementFailedException.getMessage(r, t), (Throwable)Preconditions.checkNotNull((Object)t));
        this.reason = r;
        this.path = p;
    }

    private static String getMessage(Reason r, @Nullable Throwable t) {
        String msg;
        StringBuilder sb = new StringBuilder();
        sb.append("Refinement failed: ");
        sb.append(r.toString());
        if (t != null && !(msg = Strings.nullToEmpty((String)t.getMessage())).isEmpty()) {
            sb.append(" (");
            sb.append(msg);
            sb.append(")");
        }
        return sb.toString();
    }

    public @Nullable ARGPath getErrorPath() {
        return this.path;
    }

    public void setErrorPath(ARGPath pPath) {
        this.path = (ARGPath)((Object)Preconditions.checkNotNull((Object)((Object)pPath)));
    }

    public Reason getReason() {
        return this.reason;
    }

    public static enum Reason {
        InterpolationFailed("Interpolation failed"),
        InvariantRefinementFailed("Could not find invariant"),
        StaticRefinementFailed("Static refinement failed"),
        NewtonRefinementFailed("Newton refinement failed"),
        RepeatedCounterexample("Counterexample could not be ruled out and was found again"),
        RepeatedPathPrefix("Error path prefix could not be ruled out and was used again"),
        TooMuchUnrolling("Too much unrolling"),
        InfeasibleCounterexample("External tool verified counterexample as infeasible"),
        SequenceOfAssertionsToWeak("Sequence of assertions is too weak to cover error trace"),
        TIMEOUT("SMT-solver timed out");

        private final String humanReableReason;

        private Reason(String pHumanReableReason) {
            this.humanReableReason = pHumanReableReason;
        }

        public String toString() {
            return this.humanReableReason;
        }
    }
}

