/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.propertychecker;

import org.sosy_lab.cpachecker.cfa.model.CFALabelNode;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.interval.Interval;
import org.sosy_lab.cpachecker.cpa.interval.IntervalAnalysisState;
import org.sosy_lab.cpachecker.pcc.propertychecker.PerElementPropertyChecker;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class InIntervalChecker
extends PerElementPropertyChecker {
    private final String label;
    private final String varName;
    private final Interval allowedValues;

    public InIntervalChecker(String pVariableName, String pLabel, String pMode, String pMin, String pMax) {
        this.label = pLabel;
        this.varName = pVariableName;
        this.allowedValues = new Interval(Long.parseLong(pMin), Long.parseLong(pMax));
    }

    public InIntervalChecker(String pVariableName, String pLabel, String pMode, String pValue) {
        this(pVariableName, pLabel, pMode, Integer.parseInt(pMode) == 0 ? pValue : Long.toString(Long.MIN_VALUE), Integer.parseInt(pMode) == 0 ? Long.toString(Long.MAX_VALUE) : pValue);
    }

    @Override
    public boolean satisfiesProperty(AbstractState pElemToCheck) throws UnsupportedOperationException {
        CFANode node = AbstractStates.extractLocation(pElemToCheck);
        if (node instanceof CFALabelNode && ((CFALabelNode)node).getLabel().equals(this.label)) {
            Interval interval;
            IntervalAnalysisState state = AbstractStates.extractStateByType(pElemToCheck, IntervalAnalysisState.class);
            return state != null && (interval = state.getInterval(this.varName)) != null && interval.getHigh() <= this.allowedValues.getHigh() && interval.getLow() >= this.allowedValues.getLow();
        }
        return true;
    }
}

