/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.propertychecker;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.core.interfaces.pcc.PropertyChecker;

public class PropertyCheckerBuilder {
    public static PropertyChecker buildPropertyChecker(Class<? extends PropertyChecker> propertyCheckerClass, String pCheckerParamList) throws InvalidConfigurationException {
        String[] param;
        if (pCheckerParamList.isEmpty()) {
            param = new String[]{};
        } else {
            String[] result = pCheckerParamList.split(",", -1);
            param = new String[result.length - 1];
            for (int i = 0; i < param.length; ++i) {
                param[i] = result[i];
            }
        }
        try {
            Object[] paramTypes = new Class[param.length];
            Arrays.fill(paramTypes, String.class);
            Constructor<? extends PropertyChecker> constructor = propertyCheckerClass.getConstructor((Class<?>[])paramTypes);
            return constructor.newInstance(param);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidConfigurationException(String.format("Amount of %d given parameters in option cpa.propertychecker.parameters does not match any constructor of given property checker %s.", param.length, propertyCheckerClass.getName()), (Throwable)e);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            throw new UnsupportedOperationException("Creation of specified PropertyChecker instance failed.", e);
        }
    }
}

