/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.propertychecker;

import java.util.Collection;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.pcc.PropertyChecker;
import org.sosy_lab.cpachecker.cpa.reachdef.ReachingDefState;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCodeException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.reachingdef.ReachingDefUtils;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class SingleDefinitionChecker
implements PropertyChecker {
    private final MemoryLocation varDefName;
    private ReachingDefState.ProgramDefinitionPoint point;

    public SingleDefinitionChecker(String varWithSingleDef) {
        this.varDefName = MemoryLocation.parseExtendedQualifiedName(varWithSingleDef);
    }

    @Override
    public boolean satisfiesProperty(AbstractState pElemToCheck) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean satisfiesProperty(Collection<AbstractState> pCertificate) {
        this.point = null;
        for (AbstractState elem : pCertificate) {
            ReachingDefState rdState = AbstractStates.extractStateByType(elem, ReachingDefState.class);
            if (rdState != ReachingDefState.topElement && this.stillSingleDefinition(rdState.getGlobalReachingDefinitions().get(this.varDefName)) && this.stillSingleDefinition(rdState.getLocalReachingDefinitions().get(this.varDefName))) continue;
            return false;
        }
        return true;
    }

    private boolean stillSingleDefinition(Set<ReachingDefState.DefinitionPoint> definitions) {
        if (definitions == null) {
            return true;
        }
        for (ReachingDefState.DefinitionPoint p : definitions) {
            if (!(p instanceof ReachingDefState.ProgramDefinitionPoint)) continue;
            if (this.point == null) {
                if (!this.isDefinitionInProgram((ReachingDefState.ProgramDefinitionPoint)p)) continue;
                this.point = (ReachingDefState.ProgramDefinitionPoint)p;
                continue;
            }
            if (p.equals(this.point) || !this.isDefinitionInProgram((ReachingDefState.ProgramDefinitionPoint)p)) continue;
            return false;
        }
        return true;
    }

    private boolean isDefinitionInProgram(ReachingDefState.ProgramDefinitionPoint pdp) {
        if (pdp.getDefinitionEntryLocation().hasEdgeTo(pdp.getDefinitionExitLocation())) {
            CFAEdge edge = pdp.getDefinitionEntryLocation().getEdgeTo(pdp.getDefinitionExitLocation());
            if (edge instanceof CStatementEdge) {
                CLeftHandSide left = null;
                if (((CStatementEdge)edge).getStatement() instanceof CExpressionAssignmentStatement) {
                    left = ((CExpressionAssignmentStatement)((CStatementEdge)edge).getStatement()).getLeftHandSide();
                }
                if (((CStatementEdge)edge).getStatement() instanceof CFunctionCallAssignmentStatement) {
                    left = ((CFunctionCallAssignmentStatement)((CStatementEdge)edge).getStatement()).getLeftHandSide();
                }
                if (left != null) {
                    MemoryLocation var;
                    ReachingDefUtils.VariableExtractor extractor = new ReachingDefUtils.VariableExtractor(edge);
                    extractor.resetWarning();
                    try {
                        var = left.accept(extractor);
                    }
                    catch (UnsupportedCodeException e) {
                        var = null;
                    }
                    if (var != null && var.equals(this.varDefName)) {
                        return true;
                    }
                }
            }
            if (edge instanceof CDeclarationEdge && ((CDeclarationEdge)edge).getDeclaration() instanceof CVariableDeclaration && ((CVariableDeclaration)((CDeclarationEdge)edge).getDeclaration()).getInitializer() != null && MemoryLocation.forDeclaration(((CDeclarationEdge)edge).getDeclaration()).equals(this.varDefName)) {
                return true;
            }
        }
        return false;
    }
}

