/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.propertychecker;

import java.math.BigInteger;
import org.sosy_lab.cpachecker.cfa.model.CFALabelNode;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.pcc.propertychecker.PerElementPropertyChecker;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class SingleValueChecker
extends PerElementPropertyChecker {
    private final MemoryLocation varValRep;
    private final Value varValBigInt;
    private final Value varValLong;
    private final String labelLocVarVal;

    public SingleValueChecker(String varWithSingleValue, String varValue, String labelForLocationWithSingleValue) {
        this.varValRep = MemoryLocation.parseExtendedQualifiedName(varWithSingleValue);
        this.labelLocVarVal = labelForLocationWithSingleValue;
        this.varValBigInt = new NumericValue(new BigInteger(varValue));
        this.varValLong = new NumericValue(Long.parseLong(varValue));
    }

    @Override
    public boolean satisfiesProperty(AbstractState pElemToCheck) throws UnsupportedOperationException {
        Value value;
        CFANode node = AbstractStates.extractLocation(pElemToCheck);
        return !(node instanceof CFALabelNode) || !((CFALabelNode)node).getLabel().equals(this.labelLocVarVal) || (value = AbstractStates.extractStateByType(pElemToCheck, ValueAnalysisState.class).getValueAndTypeFor(this.varValRep).getValue()).isExplicitlyKnown() && (value.equals(this.varValBigInt) || value.equals(this.varValLong));
    }
}

