/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.pcc.PCCStrategy;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.exceptions.ValidationConfigurationConstructionFailed;
import org.sosy_lab.cpachecker.pcc.util.ProofStatesInfoCollector;
import org.sosy_lab.cpachecker.pcc.util.ValidationConfigurationBuilder;
import org.sosy_lab.cpachecker.util.Triple;

@Options(prefix="pcc")
public abstract class AbstractStrategy
implements PCCStrategy,
StatisticsProvider {
    public static final String CONFIG_ZIPENTRY_NAME = "Config";
    public static final String PROOF_ZIPENTRY_NAME = "Proof";
    public static final String ADDITIONAL_PROOFINFO_ZIPENTRY_NAME = "Additional";
    private final Configuration config;
    protected LogManager logger;
    protected final PCStrategyStatistics stats;
    protected final ProofStatesInfoCollector proofInfo;
    private final Collection<Statistics> pccStats = new ArrayList<Statistics>();
    protected final Path proofFile;
    @Option(secure=true, name="useCores", description="number of cpus/cores which should be used in parallel for proof checking")
    @IntegerOption(min=1L)
    protected int numThreads = 1;
    @Option(secure=true, name="storeConfig", description="writes the validation configuration required for checking to proof")
    boolean storeConfig = false;

    protected AbstractStrategy(Configuration pConfig, LogManager pLogger, Path pProofFile) throws InvalidConfigurationException {
        pConfig.inject((Object)this, AbstractStrategy.class);
        this.config = pConfig;
        this.numThreads = Math.max(1, this.numThreads);
        this.numThreads = Math.min(Runtime.getRuntime().availableProcessors(), this.numThreads);
        this.logger = pLogger;
        this.proofFile = pProofFile;
        this.proofInfo = new ProofStatesInfoCollector(pConfig);
        this.stats = new PCStrategyStatistics(this.proofFile);
        this.pccStats.add(this.stats);
    }

    @Override
    @SuppressFBWarnings(value={"OS_OPEN_STREAM"}, justification="Do not close stream o because it wraps stream zos/fos which need to remain open and would be closed if o.close() is called.")
    public void writeProof(UnmodifiableReachedSet pReached, ConfigurableProgramAnalysis pCpa) {
        block21: {
            Path dir = this.proofFile.getParent();
            try {
                if (dir != null) {
                    Files.createDirectories(dir, new FileAttribute[0]);
                }
                try (OutputStream fos = Files.newOutputStream(this.proofFile, new OpenOption[0]);
                     ZipOutputStream zos = new ZipOutputStream(fos);){
                    boolean continueWriting;
                    zos.setLevel(9);
                    ZipEntry ze = new ZipEntry(PROOF_ZIPENTRY_NAME);
                    zos.putNextEntry(ze);
                    ObjectOutputStream o = new ObjectOutputStream(zos);
                    this.writeProofToStream(o, pReached, pCpa);
                    o.flush();
                    zos.closeEntry();
                    int index = 0;
                    do {
                        ze = new ZipEntry(ADDITIONAL_PROOFINFO_ZIPENTRY_NAME + index);
                        zos.putNextEntry(ze);
                        o = new ObjectOutputStream(zos);
                        continueWriting = this.writeAdditionalProofStream(o);
                        o.flush();
                        zos.closeEntry();
                        ++index;
                    } while (continueWriting);
                    if (!this.storeConfig) break block21;
                    ze = new ZipEntry(CONFIG_ZIPENTRY_NAME);
                    zos.putNextEntry(ze);
                    o = new ObjectOutputStream(zos);
                    try {
                        this.writeConfiguration(o);
                    }
                    catch (ValidationConfigurationConstructionFailed eIC) {
                        this.logger.logUserException(Level.WARNING, (Throwable)eIC, "Construction of validation configuration failed. Validation configuration is empty.");
                    }
                    o.flush();
                    zos.closeEntry();
                }
                catch (NotSerializableException eS) {
                    this.logger.logUserException(Level.SEVERE, (Throwable)eS, "Proof cannot be written. Class does not implement Serializable interface");
                }
                catch (InvalidConfigurationException e) {
                    this.logger.logUserException(Level.SEVERE, (Throwable)e, "Proof cannot be constructed due to conflicting configuration.");
                }
                catch (InterruptedException e) {
                    this.logger.logUserException(Level.SEVERE, (Throwable)e, "Proof cannot be written due to time out during proof construction");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.logger.log(Level.INFO, new Object[]{this.proofInfo.getInfoAsString()});
    }

    protected abstract void writeProofToStream(ObjectOutputStream var1, UnmodifiableReachedSet var2, ConfigurableProgramAnalysis var3) throws IOException, InvalidConfigurationException, InterruptedException;

    @Override
    public void readProof() throws IOException, ClassNotFoundException, InvalidConfigurationException {
        Triple<InputStream, ZipInputStream, ObjectInputStream> proofStream = this.openProofStream();
        this.readProofFromStream(proofStream.getThird());
        proofStream.getThird().close();
        proofStream.getSecond().close();
        proofStream.getFirst().close();
    }

    protected boolean writeAdditionalProofStream(ObjectOutputStream pOut) throws IOException {
        return false;
    }

    protected void writeConfiguration(ObjectOutputStream pO) throws ValidationConfigurationConstructionFailed, IOException {
        pO.writeObject(new ValidationConfigurationBuilder(this.config).getValidationConfiguration().asPropertiesString());
    }

    protected Triple<InputStream, ZipInputStream, ObjectInputStream> openProofStream() throws IOException {
        InputStream fis = Files.newInputStream(this.proofFile, new OpenOption[0]);
        ZipInputStream zis = new ZipInputStream(fis);
        ZipEntry entry = zis.getNextEntry();
        assert (entry.getName().equals(PROOF_ZIPENTRY_NAME));
        return Triple.of(fis, zis, new ObjectInputStream(zis));
    }

    public Triple<InputStream, ZipInputStream, ObjectInputStream> openAdditionalProofStream(int index) throws IOException {
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"Not a valid index. Indices must be at least zero.");
        InputStream fis = Files.newInputStream(this.proofFile, new OpenOption[0]);
        ZipInputStream zis = new ZipInputStream(fis);
        for (int i = 0; i <= index; ++i) {
            zis.getNextEntry();
        }
        ZipEntry entry = zis.getNextEntry();
        assert (entry.getName().equals("ADDITIONAL_PROOFINFO_ZIPENTRY_NAME " + index));
        return Triple.of(fis, zis, new ObjectInputStream(zis));
    }

    protected abstract void readProofFromStream(ObjectInputStream var1) throws ClassNotFoundException, InvalidConfigurationException, IOException;

    protected void addPCCStatistic(Statistics pPCCStatistic) {
        this.pccStats.add(pPCCStatistic);
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        statsCollection.addAll(this.pccStats);
    }

    @Override
    public Collection<Statistics> getAdditionalProofGenerationStatistics() {
        if (this.proofInfo != null) {
            return Collections.singleton(this.proofInfo);
        }
        return ImmutableSet.of();
    }

    public static class PCStrategyStatistics
    implements Statistics {
        protected Timer transferTimer = new Timer();
        protected Timer stopTimer = new Timer();
        protected Timer preparationTimer = new Timer();
        protected Timer propertyCheckingTimer = new Timer();
        protected int countIterations = 0;
        protected int proofSize = 0;
        protected final long fileProofSize;

        public PCStrategyStatistics(Path pFile) {
            this.fileProofSize = pFile != null ? pFile.toFile().length() : -1L;
        }

        @Override
        public String getName() {
            return "Proof Checking Strategy Statistics";
        }

        public Timer getPreparationTimer() {
            return this.preparationTimer;
        }

        public Timer getStopTimer() {
            return this.stopTimer;
        }

        public Timer getTransferTimer() {
            return this.transferTimer;
        }

        public Timer getPropertyCheckingTimer() {
            return this.propertyCheckingTimer;
        }

        public void increaseIteration() {
            ++this.countIterations;
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            out.println("Number of iterations:                     " + this.countIterations);
            out.println();
            out.println("Number of proof elements:                     " + this.proofSize);
            out.println();
            out.println("  Time for preparing proof for checking:          " + this.preparationTimer);
            out.println("  Time for abstract successor checks:     " + this.transferTimer + " (Calls: " + this.transferTimer.getNumberOfIntervals() + ")");
            out.println("  Time for covering checks:               " + this.stopTimer + " (Calls: " + this.stopTimer.getNumberOfIntervals() + ")");
            out.println(" Time for checking property:          " + this.propertyCheckingTimer);
            out.println("Proof file size (bytes):                      " + this.fileProofSize);
        }

        public void increaseProofSize(int pIncrement) {
            this.proofSize += pIncrement;
        }
    }
}

