/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy;

import com.google.common.collect.Maps;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.algorithm.CPAAlgorithm;
import org.sosy_lab.cpachecker.core.algorithm.pcc.AlgorithmWithPropertyCheck;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.PropertyChecker.PropertyCheckerCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.pcc.strategy.SequentialReadStrategy;
import org.sosy_lab.cpachecker.util.Pair;

@Options(prefix="pcc.backwardtargets")
public class BackwardTargetsReachedSetStrategy
extends SequentialReadStrategy
implements StatisticsProvider {
    private final @Nullable AlgorithmWithPropertyCheck algorithm;
    private AbstractState[] backwardTargets;
    @Option(secure=true, description="Enable to store ARG states instead of abstract states wrapped by ARG state")
    private boolean certificateStatesAsARGStates = false;

    public BackwardTargetsReachedSetStrategy(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Path pProofFile, @Nullable PropertyCheckerCPA pCpa) throws InvalidConfigurationException {
        super(pConfig, pLogger, pProofFile);
        pConfig.inject((Object)this);
        this.algorithm = pCpa == null ? null : new AlgorithmWithPropertyCheck(CPAAlgorithm.create(pCpa, pLogger, pConfig, pShutdownNotifier), pLogger, pCpa);
    }

    @Override
    public void constructInternalProofRepresentation(UnmodifiableReachedSet pReached, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        try {
            this.backwardTargets = this.detectBackwardTargets((ARGState)pReached.getFirstState(), pReached.size());
        }
        catch (ClassCastException e) {
            throw new InvalidConfigurationException("Require ARG states, as top level abstract states.");
        }
    }

    private AbstractState[] detectBackwardTargets(ARGState rootNode, int size) {
        HashSet<AbstractState> statesToStore = new HashSet<AbstractState>();
        HashMap exploreTimes = Maps.newHashMapWithExpectedSize((int)size);
        ArrayDeque<Pair<ARGState, Iterator<ARGState>>> toVisit = new ArrayDeque<Pair<ARGState, Iterator<ARGState>>>();
        int time = 0;
        exploreTimes.put(rootNode, Pair.of(time++, Integer.MAX_VALUE));
        toVisit.add(Pair.of(rootNode, rootNode.getChildren().iterator()));
        while (!toVisit.isEmpty()) {
            Pair top = (Pair)toVisit.peek();
            if (!((Iterator)top.getSecond()).hasNext()) {
                exploreTimes.put((ARGState)top.getFirst(), Pair.of((Integer)((Pair)exploreTimes.get(top.getFirst())).getFirst(), time++));
                toVisit.pop();
                continue;
            }
            ARGState uncoveredChild = this.replaceByCoveringState((ARGState)((Iterator)top.getSecond()).next());
            if (exploreTimes.containsKey(uncoveredChild)) {
                Pair exploreTime = (Pair)exploreTimes.get(uncoveredChild);
                if ((Integer)exploreTime.getFirst() >= time || (Integer)exploreTime.getSecond() <= time) continue;
                if (this.certificateStatesAsARGStates) {
                    statesToStore.add(uncoveredChild);
                    continue;
                }
                statesToStore.add(uncoveredChild.getWrappedState());
                continue;
            }
            toVisit.push(Pair.of(uncoveredChild, uncoveredChild.getChildren().iterator()));
            exploreTimes.put(uncoveredChild, Pair.of(time++, Integer.MAX_VALUE));
        }
        return statesToStore.toArray(new AbstractState[0]);
    }

    private ARGState replaceByCoveringState(ARGState pState) {
        ARGState result = pState;
        while (result.isCovered()) {
            result = result.getCoveringState();
        }
        return result;
    }

    @Override
    public boolean checkCertificate(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        Precision initPrec = pReachedSet.getPrecision(pReachedSet.getFirstState());
        for (AbstractState backwardTarget : this.backwardTargets) {
            pReachedSet.add(backwardTarget, initPrec);
        }
        return this.algorithm.run(pReachedSet).isSound();
    }

    @Override
    protected Object getProofToWrite(UnmodifiableReachedSet pReached, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        this.constructInternalProofRepresentation(pReached, pCpa);
        return this.backwardTargets;
    }

    @Override
    protected void prepareForChecking(Object pReadObject) throws InvalidConfigurationException {
        this.backwardTargets = (AbstractState[])pReadObject;
        this.stats.proofSize = this.backwardTargets.length;
    }

    @Override
    public void collectStatistics(Collection<Statistics> statsCollection) {
        super.collectStatistics(statsCollection);
        if (this.algorithm != null) {
            this.algorithm.collectStatistics(statsCollection);
        }
    }
}

