/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.pcc.PartialReachedConstructionAlgorithm;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.PropertyChecker.PropertyCheckerCPA;
import org.sosy_lab.cpachecker.cpa.location.LocationCPABackwards;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.pcc.strategy.ReachedSetStrategy;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.PartialCertificateTypeProvider;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.Pair;

@Options(prefix="pcc.partial")
public class PartialReachedSetStrategy
extends ReachedSetStrategy {
    private final PartialReachedConstructionAlgorithm certificateConstructor;
    @Option(secure=true, description="Enables proper PCC but may not work correctly for heuristics. Stops adding newly computed elements to reached set if size saved in proof is reached. If another element must be added, stops certificate checking and returns false.")
    protected boolean stopAddingAtReachedSetSize = false;
    protected int savedReachedSetSize;

    public PartialReachedSetStrategy(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Path pProofFile, @Nullable PropertyCheckerCPA pCpa) throws InvalidConfigurationException {
        super(pConfig, pLogger, pShutdownNotifier, pProofFile, pCpa);
        pConfig.inject((Object)this, PartialReachedSetStrategy.class);
        this.certificateConstructor = new PartialCertificateTypeProvider(pConfig, true).getPartialCertificateConstructor();
    }

    @Override
    public void constructInternalProofRepresentation(UnmodifiableReachedSet pReached, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        this.savedReachedSetSize = pReached.size();
        this.reachedSet = this.certificateConstructor.computePartialReachedSet(pReached, pCpa);
        this.orderReachedSetByLocation(this.reachedSet);
    }

    @Override
    protected Object getProofToWrite(UnmodifiableReachedSet pReached, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        this.constructInternalProofRepresentation(pReached, pCpa);
        return Pair.of(pReached.size(), this.reachedSet);
    }

    @Override
    protected void prepareForChecking(Object pReadProof) throws InvalidConfigurationException {
        if (CPAs.retrieveCPA(this.cpa, LocationCPABackwards.class) != null) {
            throw new InvalidConfigurationException("Partial reached set not supported as certificate for backward analysis");
        }
        if (!(pReadProof instanceof Pair)) {
            throw new InvalidConfigurationException("Proof Type requires pair of reached set size and reached set as set of abstract states.");
        }
        try {
            Pair proof = (Pair)pReadProof;
            this.savedReachedSetSize = (Integer)proof.getFirst();
            super.prepareForChecking(proof.getSecond());
        }
        catch (ClassCastException e) {
            throw new InvalidConfigurationException("Proof Type requires pair of reached set size and reached set as set of abstract states.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkCertificate(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        int certificateSize = 0;
        ArrayList<AbstractState> certificate = new ArrayList<AbstractState>(this.savedReachedSetSize);
        certificate.addAll(Arrays.asList(this.reachedSet));
        StopOperator stop = this.cpa.getStopOperator();
        Precision initialPrec = pReachedSet.getPrecision(pReachedSet.getFirstState());
        AbstractState initialState = pReachedSet.popFromWaitlist();
        if (!$assertionsDisabled) {
            if (initialState != pReachedSet.getFirstState()) throw new AssertionError();
            if (pReachedSet.size() != 1) {
                throw new AssertionError();
            }
        }
        try {
            this.stats.stopTimer.start();
            if (!stop.stop(initialState, this.statesPerLocation.get((Object)AbstractStates.extractLocation(initialState)), initialPrec)) {
                this.logger.log(Level.FINE, new Object[]{"Initial element not in partial reached set.", "Add to elements whose successors ", "must be computed."});
                certificate.add(initialState);
            }
        }
        catch (CPAException e) {
            this.logger.logException(Level.FINE, (Throwable)e, "Stop check failed for initial element.");
            boolean bl = false;
            return bl;
        }
        finally {
            this.stats.stopTimer.stop();
        }
        while (certificateSize < certificate.size()) {
            this.shutdownNotifier.shutdownIfNecessary();
            ++this.stats.countIterations;
            try {
                this.stats.transferTimer.start();
                Collection<? extends AbstractState> successors = this.cpa.getTransferRelation().getAbstractSuccessors((AbstractState)certificate.get(certificateSize++), initialPrec);
                this.stats.transferTimer.stop();
                for (AbstractState abstractState : successors) {
                    try {
                        this.stats.stopTimer.start();
                        if (stop.stop(abstractState, this.statesPerLocation.get((Object)AbstractStates.extractLocation(abstractState)), initialPrec)) continue;
                        this.logger.log(Level.FINE, new Object[]{"Successor ", abstractState, " not in partial reached set.", "Add to elements whose successors ", "must be computed."});
                        if (this.stopAddingAtReachedSetSize && this.savedReachedSetSize == certificate.size()) {
                            boolean bl = false;
                            return bl;
                        }
                        certificate.add(abstractState);
                    }
                    finally {
                        this.stats.stopTimer.stop();
                    }
                }
            }
            catch (CPATransferException e) {
                this.logger.logException(Level.FINE, (Throwable)e, "Computation of successors failed.");
                return false;
            }
            catch (CPAException e) {
                this.logger.logException(Level.FINE, (Throwable)e, "Stop check failed for successor.");
                return false;
            }
        }
        this.stats.propertyCheckingTimer.start();
        try {
            boolean bl = this.cpa.getPropChecker().satisfiesProperty(certificate);
            return bl;
        }
        finally {
            this.stats.propertyCheckingTimer.stop();
        }
    }
}

