/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.pcc.PartitioningCheckingHelper;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.PropertyChecker.PropertyCheckerCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.pcc.strategy.AbstractStrategy;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.PartitionChecker;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.PartitioningIOHelper;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.PartitioningUtils;

public class PartitionedReachedSetStrategy
extends AbstractStrategy {
    private final PartitioningIOHelper ioHelper;
    private final PropertyCheckerCPA cpa;
    private final ShutdownNotifier shutdownNotifier;

    public PartitionedReachedSetStrategy(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Path pProofFile, @Nullable PropertyCheckerCPA pCpa) throws InvalidConfigurationException {
        super(pConfig, pLogger, pProofFile);
        this.ioHelper = new PartitioningIOHelper(pConfig, pLogger, pShutdownNotifier);
        this.cpa = pCpa;
        this.shutdownNotifier = pShutdownNotifier;
        this.addPCCStatistic(this.ioHelper.getPartitioningStatistc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkCertificate(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        final AtomicBoolean checkResult = new AtomicBoolean(true);
        HashMultimap partitionNodes = HashMultimap.create();
        HashSet<AbstractState> inOtherPartition = new HashSet<AbstractState>();
        HashSet certificate = Sets.newHashSetWithExpectedSize((int)this.ioHelper.getSavedReachedSetSize());
        AbstractState initialState = pReachedSet.popFromWaitlist();
        Precision initPrec = pReachedSet.getPrecision(initialState);
        PartitioningCheckingHelper checkInfo = new PartitioningCheckingHelper(){

            @Override
            public int getCurrentCertificateSize() {
                return 0;
            }

            @Override
            public void abortCheckingPreparation() {
                checkResult.set(false);
            }
        };
        PartitionChecker checker = new PartitionChecker(initPrec, this.cpa.getStopOperator(), this.cpa.getTransferRelation(), this.ioHelper, checkInfo, this.shutdownNotifier, this.logger);
        for (int i = 0; i < this.ioHelper.getNumPartitions() && checkResult.get(); ++i) {
            checker.checkPartition(i);
            checker.addCertificatePartsToCertificate(certificate);
            checker.clearPartitionElementsSavedForInspection();
        }
        if (!checkResult.get()) {
            return false;
        }
        checker.addPartitionElements((Multimap<CFANode, AbstractState>)partitionNodes);
        checker.addElementsCheckedInOtherPartitions(inOtherPartition);
        this.logger.log(Level.INFO, new Object[]{"Add initial state to elements for which it will be checked if they are covered by partition nodes of certificate."});
        inOtherPartition.add(initialState);
        this.logger.log(Level.INFO, new Object[]{"Check if initial state and all nodes which should be contained in different partition are covered by certificate (partition node)."});
        if (!PartitioningUtils.areElementsCoveredByPartitionElement(inOtherPartition, (Multimap<CFANode, AbstractState>)partitionNodes, this.cpa.getStopOperator(), initPrec)) {
            this.logger.log(Level.SEVERE, new Object[]{"Initial state or a state which should be in other partition is not covered by certificate."});
            return false;
        }
        this.logger.log(Level.INFO, new Object[]{"Check property."});
        this.stats.getPropertyCheckingTimer().start();
        try {
            if (!this.cpa.getPropChecker().satisfiesProperty(certificate)) {
                this.logger.log(Level.SEVERE, new Object[]{"Property violated"});
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.stats.getPropertyCheckingTimer().stop();
        }
        return true;
    }

    @Override
    public void constructInternalProofRepresentation(UnmodifiableReachedSet pReached, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException, InterruptedException {
        this.ioHelper.constructInternalProofRepresentation(pReached, pCpa);
    }

    @Override
    protected void writeProofToStream(ObjectOutputStream pOut, UnmodifiableReachedSet pReached, ConfigurableProgramAnalysis pCpa) throws IOException, InvalidConfigurationException, InterruptedException {
        this.ioHelper.writeProof(pOut, pReached, pCpa);
    }

    @Override
    protected void readProofFromStream(ObjectInputStream pIn) throws ClassNotFoundException, InvalidConfigurationException, IOException {
        this.ioHelper.readProof(pIn, this.stats);
    }

    @Override
    public Collection<Statistics> getAdditionalProofGenerationStatistics() {
        ArrayList<Statistics> result = new ArrayList<Statistics>(super.getAdditionalProofGenerationStatistics());
        result.add(this.ioHelper.getGraphStatistic());
        return result;
    }
}

