/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.PropertyChecker.PropertyCheckerCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.pcc.strategy.SequentialReadStrategy;
import org.sosy_lab.cpachecker.util.AbstractStates;

@Options
public class ReachedSetStrategy
extends SequentialReadStrategy {
    protected AbstractState[] reachedSet;
    protected Multimap<CFANode, AbstractState> statesPerLocation;
    protected PropertyCheckerCPA cpa;
    protected final ShutdownNotifier shutdownNotifier;

    public ReachedSetStrategy(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Path pProofFile, @Nullable PropertyCheckerCPA pCpa) throws InvalidConfigurationException {
        super(pConfig, pLogger, pProofFile);
        this.cpa = pCpa;
        this.shutdownNotifier = pShutdownNotifier;
    }

    @Override
    public void constructInternalProofRepresentation(UnmodifiableReachedSet pReached, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        this.reachedSet = new AbstractState[pReached.size()];
        pReached.asCollection().toArray(this.reachedSet);
        if (this.reachedSet.length > 0 && this.reachedSet[0] instanceof ARGState) {
            for (int i = 0; i < this.reachedSet.length; ++i) {
                this.reachedSet[i] = ((ARGState)this.reachedSet[i]).getWrappedState();
            }
        }
        this.proofInfo.addInfoForStates(this.reachedSet);
        this.orderReachedSetByLocation(this.reachedSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkCertificate(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        StopOperator stop = this.cpa.getStopOperator();
        Precision initialPrec = pReachedSet.getPrecision(pReachedSet.getFirstState());
        AbstractState initialState = pReachedSet.popFromWaitlist();
        if (!$assertionsDisabled) {
            if (initialState != pReachedSet.getFirstState()) throw new AssertionError();
            if (pReachedSet.size() != 1) {
                throw new AssertionError();
            }
        }
        try {
            this.stats.stopTimer.start();
            if (!stop.stop(initialState, this.statesPerLocation.get((Object)AbstractStates.extractLocation(initialState)), initialPrec)) {
                this.logger.log(Level.FINE, new Object[]{"Cannot check that initial element is covered by result."});
                boolean bl = false;
                return bl;
            }
        }
        catch (CPAException e) {
            this.logger.logException(Level.FINE, (Throwable)e, "Stop check failed for initial element.");
            boolean bl = false;
            return bl;
        }
        finally {
            this.stats.stopTimer.stop();
        }
        for (AbstractState state : this.reachedSet) {
            this.shutdownNotifier.shutdownIfNecessary();
            ++this.stats.countIterations;
            try {
                this.stats.transferTimer.start();
                Collection<? extends AbstractState> successors = this.cpa.getTransferRelation().getAbstractSuccessors(state, initialPrec);
                this.stats.transferTimer.stop();
                for (AbstractState abstractState : successors) {
                    try {
                        this.stats.stopTimer.start();
                        if (stop.stop(abstractState, this.statesPerLocation.get((Object)AbstractStates.extractLocation(abstractState)), initialPrec)) continue;
                        this.logger.log(Level.FINE, new Object[]{"Cannot check that result is transitive closure.", "Successor ", abstractState, "of element ", state, "not covered by result."});
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        this.stats.stopTimer.stop();
                    }
                }
            }
            catch (CPATransferException e) {
                this.logger.logException(Level.FINE, (Throwable)e, "Computation of successors failed.");
                return false;
            }
            catch (CPAException e) {
                this.logger.logException(Level.FINE, (Throwable)e, "Stop check failed for successor.");
                return false;
            }
        }
        this.stats.propertyCheckingTimer.start();
        try {
            boolean bl = this.cpa.getPropChecker().satisfiesProperty(Arrays.asList(this.reachedSet));
            return bl;
        }
        finally {
            this.stats.propertyCheckingTimer.stop();
        }
    }

    @Override
    protected Object getProofToWrite(UnmodifiableReachedSet pReached, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        this.constructInternalProofRepresentation(pReached, pCpa);
        return this.reachedSet;
    }

    @Override
    protected void prepareForChecking(Object pReadProof) throws InvalidConfigurationException {
        try {
            this.stats.preparationTimer.start();
            if (!(pReadProof instanceof AbstractState[])) {
                throw new InvalidConfigurationException("Proof Type requires reached set as set of abstract states.");
            }
            this.reachedSet = (AbstractState[])pReadProof;
            this.stats.increaseProofSize(this.reachedSet.length);
            this.orderReachedSetByLocation(this.reachedSet);
        }
        finally {
            this.stats.preparationTimer.stop();
        }
    }

    protected void orderReachedSetByLocation(AbstractState[] pReached) {
        this.statesPerLocation = HashMultimap.create();
        for (AbstractState state : pReached) {
            this.statesPerLocation.put((Object)AbstractStates.extractLocation(state), (Object)state);
        }
    }
}

