/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.arg;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.zip.ZipInputStream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.reachedset.HistoryForwardingReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.PropertyChecker.PropertyCheckerCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.pcc.strategy.AbstractStrategy;
import org.sosy_lab.cpachecker.pcc.strategy.arg.ARG_CPAStrategy;
import org.sosy_lab.cpachecker.pcc.strategy.util.cmc.AssumptionAutomatonGenerator;
import org.sosy_lab.cpachecker.pcc.strategy.util.cmc.PartialCPABuilder;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;

public class ARG_CMCStrategy
extends AbstractStrategy {
    private final Configuration globalConfig;
    private final ShutdownNotifier shutdown;
    private final PartialCPABuilder cpaBuilder;
    private final AssumptionAutomatonGenerator automatonWriter;
    private ARGState[] roots;
    private boolean proofKnown = false;

    public ARG_CMCStrategy(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Path pProofFile, @Nullable CFA pCfa, @Nullable Specification pSpecification) throws InvalidConfigurationException {
        super(pConfig, pLogger, pProofFile);
        this.globalConfig = pConfig;
        this.shutdown = pShutdownNotifier;
        this.cpaBuilder = new PartialCPABuilder(pConfig, pLogger, pShutdownNotifier, pCfa, pSpecification);
        this.automatonWriter = new AssumptionAutomatonGenerator(pConfig, pLogger);
    }

    @Override
    public void constructInternalProofRepresentation(UnmodifiableReachedSet pReached, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException, InterruptedException {
        if (!(pReached instanceof HistoryForwardingReachedSet)) {
            throw new InvalidConfigurationException("Reached sets used by restart algorithm are not memorized. Please enable option analysis.memorizeReachedAfterRestart");
        }
        List<ReachedSet> partialReachedSets = ((HistoryForwardingReachedSet)pReached).getAllReachedSetsUsedAsDelegates();
        this.roots = new ARGState[partialReachedSets.size()];
        if (this.roots.length <= 0) {
            this.logger.log(Level.SEVERE, new Object[]{"No proof parts available. Proof cannot be generated."});
            return;
        }
        int index = 0;
        for (ReachedSet partialReached : partialReachedSets) {
            if (!(partialReached.getFirstState() instanceof ARGState) || AbstractStates.extractLocation(partialReached.getFirstState()) == null) {
                this.logger.log(Level.SEVERE, new Object[]{"Proof cannot be generated because checked property not known to be true."});
                this.roots = null;
                this.proofKnown = false;
                return;
            }
            this.stats.increaseProofSize(1);
            this.roots[index++] = (ARGState)partialReached.getFirstState();
        }
        this.proofKnown = true;
    }

    @Override
    protected void writeProofToStream(ObjectOutputStream pOut, UnmodifiableReachedSet pReached, ConfigurableProgramAnalysis pCpa) throws IOException, InvalidConfigurationException, InterruptedException {
        this.constructInternalProofRepresentation(pReached, pCpa);
        if (this.proofKnown) {
            HistoryForwardingReachedSet historyReached = (HistoryForwardingReachedSet)pReached;
            if (historyReached.getAllReachedSetsUsedAsDelegates().size() != historyReached.getCPAs().size()) {
                this.logger.log(Level.SEVERE, new Object[]{"Proof cannot be generated, inconsistency in number of analyses, contradicting number of CPAs and reached sets."});
            }
            pOut.writeInt(this.roots.length);
            for (int i = 0; i < historyReached.getCPAs().size(); ++i) {
                GlobalInfo.getInstance().setUpInfoFromCPA(historyReached.getCPAs().get(i));
                pOut.writeObject(this.roots[i]);
            }
        }
    }

    @Override
    protected void readProofFromStream(ObjectInputStream pIn) throws ClassNotFoundException, InvalidConfigurationException, IOException {
        this.roots = new ARGState[Math.max(pIn.readInt(), 0)];
    }

    @Override
    public boolean checkCertificate(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        this.logger.log(Level.INFO, new Object[]{"Start checking partial ARGs"});
        pReachedSet.popFromWaitlist();
        return this.checkAndReadSequentially();
    }

    /*
     * Exception decompiling
     */
    private boolean checkAndReadSequentially() throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 31[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkAndReadInterleaved() throws InterruptedException, CPAException {
        cpas = new ConfigurableProgramAnalysis[this.roots.length];
        try {
            factory = new ReachedSetFactory(this.globalConfig, this.logger);
            checkResult = new AtomicBoolean(true);
            partitionsAvailable = new Semaphore(0);
            readerThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Triple streams = null;
                    try {
                        streams = ARG_CMCStrategy.this.openProofStream();
                        ObjectInputStream o = (ObjectInputStream)streams.getThird();
                        o.readInt();
                        for (int i = 0; i < ARG_CMCStrategy.this.roots.length && checkResult.get(); ++i) {
                            ARG_CMCStrategy.this.logger.log(Level.FINEST, new Object[]{"Build CPA for correctly reading ", i});
                            cpas[i] = ARG_CMCStrategy.this.cpaBuilder.buildPartialCPA(i, factory);
                            GlobalInfo.getInstance().setUpInfoFromCPA(cpas[i]);
                            Object readARG = o.readObject();
                            if (!(readARG instanceof ARGState)) {
                                this.abortPreparation();
                            }
                            ARG_CMCStrategy.this.roots[i] = (ARGState)readARG;
                            if (ARG_CMCStrategy.this.shutdown.shouldShutdown()) {
                                this.abortPreparation();
                                break;
                            }
                            partitionsAvailable.release();
                        }
                    }
                    catch (IOException | ClassNotFoundException e) {
                        ARG_CMCStrategy.this.logger.logUserException(Level.SEVERE, (Throwable)e, "Partition reading failed. Stop checking");
                        this.abortPreparation();
                    }
                    catch (Exception e2) {
                        ARG_CMCStrategy.this.logger.logException(Level.SEVERE, (Throwable)e2, "Unexpected failure during proof reading");
                        this.abortPreparation();
                    }
                    finally {
                        if (streams != null) {
                            try {
                                ((ObjectInputStream)streams.getThird()).close();
                                ((ZipInputStream)streams.getSecond()).close();
                                ((InputStream)streams.getFirst()).close();
                            }
                            catch (IOException e) {
                                throw new AssertionError((Object)e);
                            }
                        }
                    }
                }

                private void abortPreparation() {
                    checkResult.set(false);
                    partitionsAvailable.release();
                }
            });
            try {
                if (this.proofKnown) {
                    partitionsAvailable.release(this.roots.length);
                } else {
                    readerThread.start();
                }
                incompleteStates = new ArrayList<ARGState>();
                i = 0;
lbl14:
                // 2 sources

                while (i < this.roots.length && checkResult.get()) {
                    partitionsAvailable.acquire();
                    incompleteStates.clear();
                    this.shutdown.shutdownIfNecessary();
                    this.logger.log(Level.INFO, new Object[]{"Start checking partial ARG ", i});
                    if (checkResult.get() && this.roots[i] != null && this.checkPartialARG(factory.create(cpas[i]), this.roots[i], incompleteStates, i, cpas[i])) ** GOTO lbl-1000
                    this.logger.log(Level.FINE, new Object[]{"Checking of partial ARG ", i, " failed."});
                    var8_10 = false;
                    ** GOTO lbl33
                }
                ** GOTO lbl45
            }
            catch (InvalidConfigurationException e) {
                try {
                    this.logger.log(Level.SEVERE, new Object[]{"Could not set up a configuration for partial ARG checking"});
                }
                catch (Throwable var9_11) {
                    this.logger.log(Level.INFO, new Object[]{"Stop checking partial ARGs"});
                    checkResult.set(false);
                    readerThread.interrupt();
                    throw var9_11;
                }
lbl33:
                // 1 sources

                this.logger.log(Level.INFO, new Object[]{"Stop checking partial ARGs"});
                checkResult.set(false);
                readerThread.interrupt();
                return var8_10;
lbl-1000:
                // 1 sources

                {
                    this.shutdown.shutdownIfNecessary();
                    if (i + 1 != this.roots.length) {
                        this.logger.log(Level.FINE, new Object[]{"Write down report of non-checked states which is provided to next partial ARG check. Report is given by assumption automaton."});
                        this.automatonWriter.writeAutomaton(this.roots[i], incompleteStates);
                        this.shutdown.shutdownIfNecessary();
                    }
                    this.logger.log(Level.INFO, new Object[]{"Checking of partial ARG ", i, " finished"});
                    ++i;
                    ** GOTO lbl14
lbl45:
                    // 1 sources

                    var7_9 = checkResult.get() != false && incompleteStates.isEmpty() != false && this.roots.length > 0;
                }
                this.logger.log(Level.INFO, new Object[]{"Stop checking partial ARGs"});
                checkResult.set(false);
                readerThread.interrupt();
                return var7_9;
                this.logger.log(Level.INFO, new Object[]{"Stop checking partial ARGs"});
                checkResult.set(false);
                readerThread.interrupt();
                return false;
            }
        }
        catch (InvalidConfigurationException e1) {
            this.logger.log(Level.SEVERE, new Object[]{"Cannot create reached sets for partial ARG checking", e1});
            return false;
        }
    }

    private boolean checkPartialARG(ReachedSet pReachedSet, ARGState pRoot, List<ARGState> pIncompleteStates, int iterationNumber, ConfigurableProgramAnalysis cpa) throws CPAException, InterruptedException, InvalidConfigurationException {
        this.logger.log(Level.FINER, new Object[]{"Set up proof checking for partial ARG ", iterationNumber});
        this.logger.log(Level.FINEST, new Object[]{"Initialize reached set"});
        CFANode mainFun = AbstractStates.extractLocation(pRoot);
        if (mainFun == null) {
            throw new InvalidConfigurationException("Require that ARG states contain location information.");
        }
        pReachedSet.add(cpa.getInitialState(mainFun, StateSpacePartition.getDefaultPartition()), cpa.getInitialPrecision(mainFun, StateSpacePartition.getDefaultPartition()));
        this.logger.log(Level.FINEST, new Object[]{"Build checking instance"});
        Preconditions.checkState((boolean)(cpa instanceof PropertyCheckerCPA), (Object)"Conflicting configuration: Partial ARGs must be checked with CPA based strategy but toplevel CPA is not a PropertyCheckerCPA as needed");
        ARG_CPAStrategy partialProofChecker = new ARG_CPAStrategy(this.globalConfig, this.logger, this.shutdown, this.proofFile, (PropertyCheckerCPA)cpa);
        this.logger.log(Level.FINER, new Object[]{"Start checking algorithm for partial ARG ", iterationNumber});
        return partialProofChecker.checkCertificate(pReachedSet, pRoot, pIncompleteStates);
    }
}

