/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.arg;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.PropertyChecker.PropertyCheckerCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.pcc.propertychecker.DefaultPropertyChecker;
import org.sosy_lab.cpachecker.pcc.strategy.arg.AbstractARGStrategy;

@Options(prefix="pcc.arg")
public class ARG_CPAStrategy
extends AbstractARGStrategy {
    @Option(secure=true, name="checkPropertyPerElement", description="Enable if used property checker implements satisfiesProperty(AbstractState) and checked property is violated for a set iff an element in this set exists for which violates the property")
    private boolean singleCheck = false;
    private List<AbstractState> visitedStates;
    private final StopOperator stop;
    private final TransferRelation transfer;

    public ARG_CPAStrategy(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Path pProofFile, @Nullable PropertyCheckerCPA pCpa) throws InvalidConfigurationException {
        super(pConfig, pLogger, pCpa == null ? new DefaultPropertyChecker() : pCpa.getPropChecker(), pShutdownNotifier, pProofFile);
        pConfig.inject((Object)this);
        if (pCpa == null) {
            this.stop = null;
            this.transfer = null;
        } else {
            if (!(pCpa.getWrappedCPAs().get(0) instanceof ARGCPA)) {
                throw new InvalidConfigurationException("Expect that the property checker cpa wraps an ARG cpa");
            }
            this.stop = ((ConfigurableProgramAnalysis)((ARGCPA)pCpa.getWrappedCPAs().get(0)).getWrappedCPAs().get(0)).getStopOperator();
            this.transfer = ((ConfigurableProgramAnalysis)((ARGCPA)pCpa.getWrappedCPAs().get(0)).getWrappedCPAs().get(0)).getTransferRelation();
        }
    }

    @Override
    protected void initChecking(ARGState pRoot) {
        if (!this.singleCheck) {
            this.visitedStates = new ArrayList<AbstractState>();
        }
    }

    @Override
    protected boolean checkCovering(ARGState pCovered, ARGState pCovering, Precision pPrecision) throws CPAException, InterruptedException {
        return this.checkCoverWithStopOp(pCovered.getWrappedState(), Collections.singleton(pCovering.getWrappedState()), pPrecision);
    }

    @Override
    protected boolean isCheckSuccessful() {
        if (!this.singleCheck) {
            try {
                this.stats.getPropertyCheckingTimer().start();
                boolean bl = this.propChecker.satisfiesProperty(this.visitedStates);
                return bl;
            }
            finally {
                this.stats.getPropertyCheckingTimer().stop();
            }
        }
        return true;
    }

    @Override
    protected boolean isCheckComplete() {
        return true;
    }

    @Override
    protected boolean checkForStatePropertyAndOtherStateActions(ARGState pState) {
        if (this.singleCheck) {
            return super.checkForStatePropertyAndOtherStateActions(pState);
        }
        this.visitedStates.add(pState);
        return true;
    }

    @Override
    protected boolean prepareNextWaitlistIteration(ReachedSet pReachedSet) {
        return true;
    }

    @Override
    protected boolean checkSuccessors(ARGState pPredecessor, Collection<ARGState> pSuccessors, Precision pPrecision) throws InterruptedException, CPAException {
        ArrayList<AbstractState> wrappedSuccessors = new ArrayList<AbstractState>(pSuccessors.size());
        for (ARGState succ : pSuccessors) {
            wrappedSuccessors.add(succ.getWrappedState());
        }
        Collection<? extends AbstractState> computedSuccessors = this.transfer.getAbstractSuccessors(pPredecessor.getWrappedState(), pPrecision);
        for (AbstractState abstractState : computedSuccessors) {
            if (this.checkCoverWithStopOp(abstractState, wrappedSuccessors, pPrecision)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean addSuccessors(Collection<ARGState> pSuccessors, ReachedSet pReachedSet, Precision pPrecision) {
        for (ARGState argS : pSuccessors) {
            pReachedSet.add(argS, pPrecision);
        }
        return true;
    }

    @Override
    protected boolean treatStateIfCoveredByUnkownState(ARGState pCovered, ARGState pCoveringState, ReachedSet pReachedSet, Precision pPrecision) {
        pReachedSet.add(pCoveringState, pPrecision);
        return false;
    }

    private boolean checkCoverWithStopOp(AbstractState pCovered, Collection<AbstractState> pCoverElems, Precision pPrecision) throws CPAException, InterruptedException {
        return this.stop.stop(pCovered, pCoverElems, pPrecision);
    }
}

