/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.parallel;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.core.interfaces.pcc.PropertyChecker;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.PropertyChecker.PropertyCheckerCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.bam.BAMARGBlockStartState;
import org.sosy_lab.cpachecker.cpa.bam.BAMCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.pcc.propertychecker.NoTargetStateChecker;
import org.sosy_lab.cpachecker.pcc.strategy.SequentialReadStrategy;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Pair;

@Options
public class ARGProofCheckerParallelStrategy
extends SequentialReadStrategy {
    private ARGState[] args;
    private ProofChecker checker;
    private PropertyChecker propChecker;

    public ARGProofCheckerParallelStrategy(Configuration pConfig, LogManager pLogger, Path pProofFile, @Nullable ProofChecker pChecker) throws InvalidConfigurationException {
        super(pConfig, pLogger, pProofFile);
        this.checker = pChecker;
        this.propChecker = new NoTargetStateChecker();
        if (pChecker instanceof PropertyCheckerCPA) {
            this.propChecker = ((PropertyCheckerCPA)pChecker).getPropChecker();
        }
    }

    @Override
    public void constructInternalProofRepresentation(UnmodifiableReachedSet pReached, ConfigurableProgramAnalysis pCpa) {
        if (this.correctReachedSetFormatForProof(pReached)) {
            this.args = this.orderBAMBlockStartStates((ARGState)pReached.getFirstState());
            this.args[this.args.length - 1] = (ARGState)pReached.getFirstState();
        }
    }

    @Override
    public boolean checkCertificate(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        this.logger.log(Level.INFO, new Object[]{"Proof check algorithm started"});
        try {
            int j;
            Collection<ARGState> returnNodes;
            int numElems;
            List<ARGState> argStates;
            StateCheckingHelper[] helper = new StateCheckingHelper[this.numThreads - 1];
            Thread[] helperThreads = new Thread[this.numThreads - 1];
            CyclicBarrier barrier = new CyclicBarrier(this.numThreads);
            CommonResult result = new CommonResult(this.numThreads);
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("ARGProofCheckerParallelStrategy-checkCertificate-%d").build();
            for (int i = 0; i < helper.length; ++i) {
                helper[i] = new StateCheckingHelper(barrier, result, this.propChecker, this.checker);
                helperThreads[i] = threadFactory.newThread(helper[i]);
                helperThreads[i].start();
            }
            ArrayList<ARGState> partialReturnNodes = new ArrayList<ARGState>();
            for (int i = 0; i < this.args.length - 2; ++i) {
                int j2;
                BAMARGBlockStartState bamState = (BAMARGBlockStartState)this.args[i];
                Block block = ((BAMCPA)this.checker).getBlockPartitioning().getBlockForCallNode(AbstractStates.extractLocation(bamState));
                argStates = this.getARGElements(bamState.getAnalyzedBlock());
                numElems = argStates.size() / this.numThreads;
                for (j2 = 0; j2 < helper.length; ++j2) {
                    helper[j2].setCheckingInfo(j2 * numElems, numElems, argStates, block);
                }
                barrier.await();
                for (j2 = helper.length * numElems; j2 < argStates.size(); ++j2) {
                    if (ARGProofCheckerParallelStrategy.checkInnerElement(this.propChecker, this.checker, argStates.get(j2), block, partialReturnNodes)) continue;
                    return false;
                }
                result.addReturnNodes(partialReturnNodes);
                partialReturnNodes.clear();
                returnNodes = result.getResult();
                if (returnNodes == null) {
                    return false;
                }
                ((BAMCPA)this.checker).getBamPccManager().setCorrectARG(Pair.of(this.args[i], block), returnNodes);
            }
            ARGState root = this.args[this.args.length - 1];
            AbstractState initialState = pReachedSet.popFromWaitlist();
            this.logger.log(Level.FINE, new Object[]{"Checking root state"});
            if (!this.checker.isCoveredBy(initialState, root) || !this.checker.isCoveredBy(root, initialState)) {
                return false;
            }
            argStates = this.getARGElements(root);
            numElems = argStates.size() / this.numThreads;
            for (j = 0; j < helper.length; ++j) {
                helper[j].setCheckingInfo(j * numElems, numElems, argStates);
            }
            barrier.await();
            for (j = helper.length * numElems; j < argStates.size(); ++j) {
                if (ARGProofCheckerParallelStrategy.checkElement(this.propChecker, this.checker, argStates.get(j))) continue;
                return false;
            }
            for (j = 0; j < helper.length; ++j) {
                helperThreads[j].join();
                if (result.isSuccess()) continue;
                return false;
            }
            returnNodes = result.getResult();
            if (returnNodes == null) {
                return false;
            }
        }
        catch (BrokenBarrierException e) {
            this.logger.log(Level.SEVERE, new Object[]{"Synchronization with barrier faild."});
            return false;
        }
        return true;
    }

    private List<ARGState> getARGElements(ARGState pRoot) {
        HashSet<ARGState> seen = new HashSet<ARGState>();
        ArrayDeque<ARGState> toVisit = new ArrayDeque<ARGState>();
        seen.add(pRoot);
        toVisit.add(pRoot);
        while (!toVisit.isEmpty()) {
            ARGState current = (ARGState)toVisit.pop();
            if (current.isCovered()) {
                if (!seen.add(current.getCoveringState())) continue;
                toVisit.add(current.getCoveringState());
                continue;
            }
            for (ARGState state : current.getChildren()) {
                if (!seen.add(state)) continue;
                toVisit.add(state);
            }
        }
        return new ArrayList<ARGState>(seen);
    }

    private static boolean checkInnerElement(PropertyChecker propChecker, ProofChecker checker, ARGState toCheck, Block block, Collection<ARGState> returnNodes) {
        if (ARGProofCheckerParallelStrategy.checkElement(propChecker, checker, toCheck)) {
            if (!propChecker.satisfiesProperty(toCheck)) {
                returnNodes.add(toCheck);
                CFANode node = AbstractStates.extractLocation(toCheck);
                if (block.isReturnNode(node)) {
                    returnNodes.add(toCheck);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean checkElement(PropertyChecker propChecker, ProofChecker checker, ARGState toCheck) {
        try {
            if (!propChecker.satisfiesProperty(toCheck)) {
                return false;
            }
            if (toCheck.isCovered()) {
                if (!ARGProofCheckerParallelStrategy.isCoveringCycleFree(toCheck)) {
                    return false;
                }
                if (!checker.isCoveredBy(toCheck, toCheck.getCoveringState())) {
                    return false;
                }
            } else {
                Collection<ARGState> successors = toCheck.getChildren();
                if (!checker.areAbstractSuccessors(toCheck, null, successors)) {
                    return false;
                }
            }
        }
        catch (InterruptedException | CPAException e) {
            return false;
        }
        return true;
    }

    private static boolean isCoveringCycleFree(ARGState pState) {
        HashSet<ARGState> seen = new HashSet<ARGState>();
        seen.add(pState);
        while (pState.isCovered()) {
            boolean isNew = seen.add(pState = pState.getCoveringState());
            if (isNew) continue;
            return false;
        }
        return true;
    }

    private boolean correctReachedSetFormatForProof(UnmodifiableReachedSet pReached) {
        if (!(pReached.getFirstState() instanceof ARGState) || AbstractStates.extractLocation(pReached.getFirstState()) == null) {
            this.logger.log(Level.SEVERE, new Object[]{"Proof cannot be generated because checked property not known to be true."});
            return false;
        }
        return true;
    }

    @Override
    protected Object getProofToWrite(UnmodifiableReachedSet pReached, ConfigurableProgramAnalysis pCpa) {
        this.constructInternalProofRepresentation(pReached, pCpa);
        return this.args;
    }

    @Override
    protected void prepareForChecking(Object pReadProof) throws InvalidConfigurationException {
        try {
            this.stats.getPreparationTimer().start();
            if (!(pReadProof instanceof ARGState[]) && ((ARGState[])pReadProof).length >= 1) {
                throw new InvalidConfigurationException("Proof Strategy requires ARG.");
            }
            this.args = (ARGState[])pReadProof;
        }
        finally {
            this.stats.getPreparationTimer().stop();
        }
    }

    private ARGState[] orderBAMBlockStartStates(ARGState pMainRoot) {
        HashMap<BAMARGBlockStartState, Pair<Integer, BitSet>> map = new HashMap<BAMARGBlockStartState, Pair<Integer, BitSet>>();
        ArrayDeque<BAMARGBlockStartState> blocksToVisit = new ArrayDeque<BAMARGBlockStartState>();
        int nextIndex = 0;
        HashSet<ARGState> seen = new HashSet<ARGState>();
        ArrayDeque<ARGState> toVisit = new ArrayDeque<ARGState>();
        seen.add(pMainRoot);
        toVisit.add(pMainRoot);
        while (!toVisit.isEmpty()) {
            ARGState current = (ARGState)toVisit.pop();
            if (current.isCovered()) {
                if (!seen.add(current.getCoveringState())) continue;
                toVisit.add(current.getCoveringState());
                continue;
            }
            if (current instanceof BAMARGBlockStartState && !map.containsKey(current)) {
                map.put((BAMARGBlockStartState)current, Pair.of(nextIndex, new BitSet()));
                ++nextIndex;
                blocksToVisit.add((BAMARGBlockStartState)current);
            }
            for (ARGState state : current.getChildren()) {
                if (!seen.add(state)) continue;
                toVisit.add(state);
            }
        }
        while (!blocksToVisit.isEmpty()) {
            this.traverseARG((BAMARGBlockStartState)blocksToVisit.pop(), map, blocksToVisit, nextIndex);
        }
        return this.topologySort(map);
    }

    private void traverseARG(BAMARGBlockStartState pRoot, Map<BAMARGBlockStartState, Pair<Integer, BitSet>> graphToComplete, Deque<BAMARGBlockStartState> pBlocksToVisit, int pNextIndex) {
        HashSet<ARGState> seen = new HashSet<ARGState>();
        ArrayDeque<ARGState> toVisit = new ArrayDeque<ARGState>();
        seen.add(pRoot.getAnalyzedBlock());
        toVisit.add(pRoot.getAnalyzedBlock());
        while (!toVisit.isEmpty()) {
            ARGState current = (ARGState)toVisit.pop();
            if (current.isCovered()) {
                if (!seen.add(current.getCoveringState())) continue;
                toVisit.add(current.getCoveringState());
                continue;
            }
            if (current instanceof BAMARGBlockStartState) {
                if (!graphToComplete.containsKey(current)) {
                    graphToComplete.put((BAMARGBlockStartState)current, Pair.of(pNextIndex, new BitSet()));
                    ++pNextIndex;
                    pBlocksToVisit.add((BAMARGBlockStartState)current);
                }
                graphToComplete.get(pRoot).getSecond().set(graphToComplete.get(current).getFirst());
            }
            for (ARGState state : current.getChildren()) {
                if (!seen.add(state)) continue;
                toVisit.add(state);
            }
        }
    }

    private ARGState[] topologySort(Map<BAMARGBlockStartState, Pair<Integer, BitSet>> pMap) {
        ARGState[] result = new ARGState[pMap.size() + 1];
        int nextPos = 0;
        int size = 0;
        ArrayList<BAMARGBlockStartState> consider = new ArrayList<BAMARGBlockStartState>(pMap.keySet());
        while (!consider.isEmpty()) {
            int i;
            if (size == consider.size()) {
                this.logger.log(Level.WARNING, new Object[]{"Cannot topology sort ARGs for blocks due to recursion."});
                return new ARGState[1];
            }
            size = consider.size();
            ArrayList<Integer> deleteEdges = new ArrayList<Integer>();
            for (i = consider.size() - 1; i >= 0; --i) {
                if (pMap.get(consider.get(i)).getSecond().cardinality() != 0) continue;
                deleteEdges.add(pMap.get(consider.get(i)).getFirst());
                result[nextPos] = (ARGState)consider.remove(i);
                ++nextPos;
            }
            for (i = consider.size() - 1; i >= 0; --i) {
                BitSet set = pMap.get(consider.get(i)).getSecond();
                Iterator iterator = deleteEdges.iterator();
                while (iterator.hasNext()) {
                    int deleteEdge = (Integer)iterator.next();
                    set.clear(deleteEdge);
                }
            }
        }
        return result;
    }

    private static class CommonResult {
        private boolean success = true;
        private int max;
        private int numSetResults;
        private List<ARGState> returnNodes;

        public CommonResult(int maxParticipants) {
            this.max = maxParticipants;
            this.numSetResults = 0;
            this.returnNodes = new ArrayList<ARGState>();
        }

        public boolean isSuccess() {
            return this.success;
        }

        public synchronized void setFailure() {
            this.success = false;
            this.increaseSetResults();
        }

        public synchronized void addReturnNodes(Collection<ARGState> partialReturnNodes) {
            this.returnNodes.addAll(partialReturnNodes);
            this.increaseSetResults();
        }

        public synchronized Collection<ARGState> getResult() throws InterruptedException {
            try {
                while (this.numSetResults != this.max) {
                    this.wait();
                }
                if (!this.success) {
                    Collection<ARGState> collection = null;
                    return collection;
                }
                List<ARGState> list = this.returnNodes;
                return list;
            }
            finally {
                this.numSetResults = 0;
                this.returnNodes = new ArrayList<ARGState>();
            }
        }

        private void increaseSetResults() {
            ++this.numSetResults;
            if (this.numSetResults == this.max) {
                this.notify();
            }
        }
    }

    private static class StateCheckingHelper
    implements Runnable {
        private boolean lastRound;
        private int startCheck;
        private int numElemsToCheck;
        private CyclicBarrier barrier;
        private List<ARGState> states;
        private CommonResult result;
        private PropertyChecker propC;
        private ProofChecker proofC;
        private Block currentB;

        public StateCheckingHelper(CyclicBarrier pBarrier, CommonResult pResult, PropertyChecker pPropCheck, ProofChecker pProofCheck) {
            this.barrier = pBarrier;
            this.result = pResult;
            this.propC = pPropCheck;
            this.proofC = pProofCheck;
        }

        public void setCheckingInfo(int pStartIndex, int pNumberElems, List<ARGState> argStates) {
            this.lastRound = true;
            this.startCheck = pStartIndex;
            this.numElemsToCheck = pNumberElems;
            this.states = argStates;
        }

        public void setCheckingInfo(int pStartIndex, int pNumberElems, List<ARGState> argStates, Block block) {
            this.lastRound = false;
            this.startCheck = pStartIndex;
            this.numElemsToCheck = pNumberElems;
            this.currentB = block;
            this.states = argStates;
        }

        @Override
        public void run() {
            ArrayList<ARGState> returnNodes = new ArrayList<ARGState>();
            boolean fail = false;
            try {
                do {
                    this.barrier.await();
                    int end = this.startCheck + this.numElemsToCheck;
                    for (int i = this.startCheck; i < end; ++i) {
                        if (this.lastRound) {
                            if (ARGProofCheckerParallelStrategy.checkElement(this.propC, this.proofC, this.states.get(i))) continue;
                            fail = true;
                            break;
                        }
                        if (ARGProofCheckerParallelStrategy.checkInnerElement(this.propC, this.proofC, this.states.get(i), this.currentB, returnNodes)) continue;
                        fail = true;
                        break;
                    }
                    if (!fail) {
                        if (this.lastRound) continue;
                        this.result.addReturnNodes(returnNodes);
                        returnNodes.clear();
                        continue;
                    }
                    this.result.setFailure();
                } while (!this.lastRound && !fail);
            }
            catch (InterruptedException | BrokenBarrierException e) {
                this.result.setFailure();
            }
        }
    }
}

