/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.parallel;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.PropertyChecker.PropertyCheckerCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.pcc.strategy.PartialReachedSetStrategy;
import org.sosy_lab.cpachecker.util.AbstractStates;

@Options(prefix="pcc.partial")
public class PartialReachedSetParallelStrategy
extends PartialReachedSetStrategy {
    @Option(secure=true, description="If enabled, distributes checking of partial elements depending on actual checking costs, else uses the number of elements")
    private boolean enableLoadDistribution = false;

    public PartialReachedSetParallelStrategy(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Path pProofFile, @Nullable PropertyCheckerCPA pCpa) throws InvalidConfigurationException {
        super(pConfig, pLogger, pShutdownNotifier, pProofFile, pCpa);
        pConfig.inject((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkCertificate(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        boolean bl;
        boolean i;
        ArrayList<AbstractState> certificate = new ArrayList<AbstractState>(this.savedReachedSetSize);
        Precision initialPrec = pReachedSet.getPrecision(pReachedSet.getFirstState());
        AtomicBoolean result = new AtomicBoolean(true);
        AtomicInteger nextElement = new AtomicInteger(0);
        ReentrantLock lock = new ReentrantLock();
        Semaphore waitForThreads = new Semaphore(0);
        PartialChecker[] transitiveClosureThreads = new PartialChecker[this.numThreads];
        for (i = false; i < transitiveClosureThreads.length; i += 1) {
            transitiveClosureThreads[i] = this.enableLoadDistribution ? new PartialChecker(nextElement, certificate, initialPrec, result, (Lock)lock, waitForThreads) : new PartialChecker(i ? 1 : 0, certificate, initialPrec, result, (Lock)lock, waitForThreads);
            transitiveClosureThreads[i].start();
        }
        waitForThreads.acquire(this.numThreads);
        if (!result.get()) {
            this.logger.log(Level.FINE, new Object[]{"Checking failed"});
            i = false;
            return i;
        }
        AbstractState initialState = pReachedSet.popFromWaitlist();
        assert (initialState == pReachedSet.getFirstState() && pReachedSet.size() == 1);
        try {
            this.stats.getStopTimer().start();
            if (!this.cpa.getStopOperator().stop(initialState, this.statesPerLocation.get((Object)AbstractStates.extractLocation(initialState)), initialPrec)) {
                this.logger.log(Level.FINE, new Object[]{"Initial element not in partial reached set."});
                boolean bl2 = false;
                return bl2;
            }
        }
        catch (CPAException e) {
            this.logger.logException(Level.FINE, (Throwable)e, "Stop check failed for initial element.");
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.stats.getStopTimer().stop();
        }
        this.stats.getPropertyCheckingTimer().start();
        try {
            bl = this.cpa.getPropChecker().satisfiesProperty(certificate);
        }
        catch (Throwable throwable) {
            this.stats.getPropertyCheckingTimer().stop();
            throw throwable;
        }
        this.stats.getPropertyCheckingTimer().stop();
        return bl;
        finally {
            for (PartialChecker t : transitiveClosureThreads) {
                t.interrupt();
            }
        }
    }

    private class PartialChecker
    extends Thread {
        private final int startIndex;
        private final List<AbstractState> certificate;
        private final Precision initPrec;
        private final AtomicInteger indexProvider;
        private final AtomicBoolean result;
        private final Lock mutex;
        private final Semaphore coordination;

        public PartialChecker(int pStartIndex, List<AbstractState> pCertificate, Precision pInitPrec, AtomicBoolean pResult, Lock pMutex, Semaphore pCoordinate) {
            this.startIndex = pStartIndex;
            this.certificate = pCertificate;
            this.initPrec = pInitPrec;
            this.result = pResult;
            this.mutex = pMutex;
            this.coordination = pCoordinate;
            assert (!PartialReachedSetParallelStrategy.this.enableLoadDistribution);
            this.indexProvider = null;
        }

        public PartialChecker(AtomicInteger pIndexProvider, List<AbstractState> pCertificate, Precision pInitPrec, AtomicBoolean pResult, Lock pMutex, Semaphore pCoordinate) {
            assert (PartialReachedSetParallelStrategy.this.enableLoadDistribution);
            this.startIndex = 0;
            this.certificate = pCertificate;
            this.initPrec = pInitPrec;
            this.result = pResult;
            this.mutex = pMutex;
            this.coordination = pCoordinate;
            this.indexProvider = pIndexProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<AbstractState> currentStates = new ArrayList<AbstractState>(PartialReachedSetParallelStrategy.this.savedReachedSetSize / PartialReachedSetParallelStrategy.this.numThreads);
            try {
                int i;
                int index = 0;
                int n = i = PartialReachedSetParallelStrategy.this.enableLoadDistribution ? this.indexProvider.getAndIncrement() : this.startIndex;
                while (i < PartialReachedSetParallelStrategy.this.reachedSet.length && this.result.get()) {
                    PartialReachedSetParallelStrategy.this.shutdownNotifier.shutdownIfNecessary();
                    currentStates.add(PartialReachedSetParallelStrategy.this.reachedSet[i]);
                    while (index < currentStates.size() && this.result.get()) {
                        PartialReachedSetParallelStrategy.this.shutdownNotifier.shutdownIfNecessary();
                        for (AbstractState abstractState : PartialReachedSetParallelStrategy.this.cpa.getTransferRelation().getAbstractSuccessors((AbstractState)currentStates.get(index++), this.initPrec)) {
                            if (PartialReachedSetParallelStrategy.this.cpa.getStopOperator().stop(abstractState, PartialReachedSetParallelStrategy.this.statesPerLocation.get((Object)AbstractStates.extractLocation(abstractState)), this.initPrec)) continue;
                            if (PartialReachedSetParallelStrategy.this.stopAddingAtReachedSetSize && PartialReachedSetParallelStrategy.this.savedReachedSetSize <= this.certificate.size() + currentStates.size()) {
                                PartialReachedSetParallelStrategy.this.logger.log(Level.FINE, new Object[]{"Too many states recomputed"});
                                this.abort();
                                return;
                            }
                            currentStates.add(abstractState);
                        }
                    }
                    i = PartialReachedSetParallelStrategy.this.enableLoadDistribution ? this.indexProvider.getAndIncrement() : i + PartialReachedSetParallelStrategy.this.numThreads;
                }
                this.mutex.lock();
                try {
                    this.certificate.addAll(currentStates);
                }
                finally {
                    this.mutex.unlock();
                }
                this.coordination.release();
            }
            catch (CPATransferException e) {
                PartialReachedSetParallelStrategy.this.logger.logUserException(Level.FINE, (Throwable)e, "Computation of successors failed.");
                this.abort();
            }
            catch (CPAException e) {
                PartialReachedSetParallelStrategy.this.logger.logUserException(Level.FINE, (Throwable)e, "Stop check failed for successor.");
                this.abort();
            }
            catch (Exception e) {
                PartialReachedSetParallelStrategy.this.logger.logException(Level.WARNING, (Throwable)e, "Unknown problem");
                this.abort();
            }
        }

        private void abort() {
            this.result.set(false);
            this.coordination.release(PartialReachedSetParallelStrategy.this.numThreads);
        }
    }
}

