/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.parallel;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.PropertyChecker.PropertyCheckerCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.pcc.strategy.ReachedSetStrategy;
import org.sosy_lab.cpachecker.util.AbstractStates;

@Options
public class ReachedSetParallelStrategy
extends ReachedSetStrategy {
    public ReachedSetParallelStrategy(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Path pProofFile, @Nullable PropertyCheckerCPA pCpa) throws InvalidConfigurationException {
        super(pConfig, pLogger, pShutdownNotifier, pProofFile, pCpa);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkCertificate(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        int i;
        StopOperator stop = this.cpa.getStopOperator();
        Precision initialPrec = pReachedSet.getPrecision(pReachedSet.getFirstState());
        AbstractState initialState = pReachedSet.popFromWaitlist();
        assert (initialState == pReachedSet.getFirstState() && pReachedSet.size() == 1);
        try {
            if (!stop.stop(initialState, this.statesPerLocation.get((Object)AbstractStates.extractLocation(initialState)), initialPrec)) {
                this.logger.log(Level.FINE, new Object[]{"Cannot check that initial element is covered by result."});
                return false;
            }
        }
        catch (CPAException e) {
            this.logger.logException(Level.FINE, (Throwable)e, "Stop check failed for initial element.");
            return false;
        }
        CheckingHelper[] helper = new CheckingHelper[this.numThreads - 1];
        Thread[] helperThreads = new Thread[this.numThreads - 1];
        int length = this.reachedSet.length / this.numThreads;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("ReachedSetParallelStrategy-checkCertificate-%d").build();
        for (int i2 = 0; i2 < helper.length; ++i2) {
            this.shutdownNotifier.shutdownIfNecessary();
            helper[i2] = new CheckingHelper(i2 * length, length, initialPrec);
            helperThreads[i2] = threadFactory.newThread(helper[i2]);
            helperThreads[i2].start();
        }
        for (i = length * helper.length; i < this.reachedSet.length; ++i) {
            this.shutdownNotifier.shutdownIfNecessary();
            this.stats.increaseIteration();
            try {
                Collection<? extends AbstractState> successors = this.cpa.getTransferRelation().getAbstractSuccessors(this.reachedSet[i], initialPrec);
                for (AbstractState abstractState : successors) {
                    if (stop.stop(abstractState, this.statesPerLocation.get((Object)AbstractStates.extractLocation(abstractState)), initialPrec)) continue;
                    this.logger.log(Level.FINE, new Object[]{"Cannot check that result is transitive closure.", "Successor ", abstractState, "of element ", this.reachedSet[i], "not covered by result."});
                    return false;
                }
                continue;
            }
            catch (CPATransferException e) {
                this.logger.logException(Level.FINE, (Throwable)e, "Computation of successors failed.");
                return false;
            }
            catch (CPAException e) {
                this.logger.logException(Level.FINE, (Throwable)e, "Stop check failed for successor.");
                return false;
            }
        }
        for (i = 0; i < helper.length; ++i) {
            helperThreads[i].join();
            if (helper[i].result) continue;
            return false;
        }
        this.stats.getPropertyCheckingTimer().start();
        try {
            boolean bl = this.cpa.getPropChecker().satisfiesProperty(Arrays.asList(this.reachedSet));
            return bl;
        }
        finally {
            this.stats.getPropertyCheckingTimer().stop();
        }
    }

    protected class CheckingHelper
    implements Runnable {
        private int start;
        private int numElem;
        private Precision initialPrec;
        private boolean result = true;

        protected CheckingHelper(int startIndex, int pNumElem, Precision pInitialPrec) {
            if (startIndex < 0 || pNumElem < 1) {
                throw new NumberFormatException("Start index must be postive or 0 and number of elements to check must be positive.");
            }
            this.start = startIndex;
            this.numElem = pNumElem;
            this.initialPrec = pInitialPrec;
        }

        @Override
        public void run() {
            StopOperator stop = ReachedSetParallelStrategy.this.cpa.getStopOperator();
            for (int i = this.start; i < this.start + this.numElem; ++i) {
                try {
                    Collection<? extends AbstractState> successors = ReachedSetParallelStrategy.this.cpa.getTransferRelation().getAbstractSuccessors(ReachedSetParallelStrategy.this.reachedSet[i], this.initialPrec);
                    for (AbstractState abstractState : successors) {
                        if (stop.stop(abstractState, ReachedSetParallelStrategy.this.statesPerLocation.get((Object)AbstractStates.extractLocation(abstractState)), this.initialPrec)) continue;
                        ReachedSetParallelStrategy.this.logger.log(Level.FINE, new Object[]{"Cannot check that result is transitive closure.", "Successor ", abstractState, "of element ", ReachedSetParallelStrategy.this.reachedSet[i], "not covered by result."});
                        this.result = false;
                    }
                    continue;
                }
                catch (InterruptedException | CPATransferException e) {
                    ReachedSetParallelStrategy.this.logger.logException(Level.FINE, (Throwable)e, "Computation of successors failed.");
                    this.result = false;
                    continue;
                }
                catch (CPAException e) {
                    ReachedSetParallelStrategy.this.logger.logException(Level.FINE, (Throwable)e, "Stop check failed for successor.");
                    this.result = false;
                }
            }
        }
    }
}

