/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.parallel.interleaved;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.zip.ZipInputStream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.PropertyChecker.PropertyCheckerCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.pcc.strategy.AbstractStrategy;
import org.sosy_lab.cpachecker.pcc.strategy.parallel.ParallelPartitionChecker;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.PartialReachedSetDirectedGraph;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.PartitioningIOHelper;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.PartitioningUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.Triple;

public class PartialReachedSetIOCheckingInterleavedStrategy
extends AbstractStrategy {
    private final PartitioningIOHelper ioHelper;
    private final PropertyCheckerCPA cpa;
    private final ShutdownNotifier shutdownNotifier;
    private final Lock lock = new ReentrantLock();

    public PartialReachedSetIOCheckingInterleavedStrategy(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Path pProofFile, @Nullable PropertyCheckerCPA pCpa) throws InvalidConfigurationException {
        super(pConfig, pLogger, pProofFile);
        this.ioHelper = new PartitioningIOHelper(pConfig, pLogger, pShutdownNotifier);
        this.cpa = pCpa;
        this.shutdownNotifier = pShutdownNotifier;
        this.addPCCStatistic(this.ioHelper.getPartitioningStatistc());
    }

    @Override
    public void constructInternalProofRepresentation(UnmodifiableReachedSet pReached, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        throw new InvalidConfigurationException("Interleaved proof reading and checking strategies do not  support internal PCC with result check algorithm");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkCertificate(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        AtomicBoolean checkResult = new AtomicBoolean(true);
        AtomicInteger nextId = new AtomicInteger(0);
        AtomicInteger availableForChecking = new AtomicInteger(0);
        Semaphore partitionsRead = new Semaphore(0);
        Semaphore partitionChecked = new Semaphore(0);
        HashSet certificate = Sets.newHashSetWithExpectedSize((int)this.ioHelper.getSavedReachedSetSize());
        HashMultimap partitionNodes = HashMultimap.create();
        ArrayList<AbstractState> inOtherPartition = new ArrayList<AbstractState>();
        AbstractState initialState = pReachedSet.popFromWaitlist();
        Precision initPrec = pReachedSet.getPrecision(initialState);
        this.logger.log(Level.INFO, new Object[]{"Create and start threads"});
        ExecutorService executor = Executors.newFixedThreadPool(this.numThreads - 1);
        try {
            boolean bl;
            for (int i = 0; i < this.numThreads - 1; ++i) {
                executor.execute(new ParallelPartitionChecker(availableForChecking, nextId, checkResult, partitionsRead, partitionChecked, this.lock, this.ioHelper, (Multimap<CFANode, AbstractState>)partitionNodes, certificate, inOtherPartition, initPrec, this.cpa.getStopOperator(), this.cpa.getTransferRelation(), this.shutdownNotifier, this.logger));
            }
            new PartitionReader(checkResult, partitionsRead, partitionChecked).run();
            if (!checkResult.get()) {
                bl = false;
                return bl;
            }
            new ParallelPartitionChecker(availableForChecking, nextId, checkResult, partitionsRead, partitionChecked, this.lock, this.ioHelper, (Multimap<CFANode, AbstractState>)partitionNodes, certificate, inOtherPartition, initPrec, this.cpa.getStopOperator(), this.cpa.getTransferRelation(), this.shutdownNotifier, this.logger).run();
            partitionChecked.acquire(this.ioHelper.getNumPartitions());
            if (!checkResult.get()) {
                bl = false;
                return bl;
            }
            this.logger.log(Level.INFO, new Object[]{"Add initial state to elements for which it will be checked if they are covered by partition nodes of certificate."});
            inOtherPartition.add(initialState);
            this.logger.log(Level.INFO, new Object[]{"Check if initial state and all nodes which should be contained in different partition are covered by certificate (partition node)."});
            if (!PartitioningUtils.areElementsCoveredByPartitionElement(inOtherPartition, (Multimap<CFANode, AbstractState>)partitionNodes, this.cpa.getStopOperator(), initPrec)) {
                this.logger.log(Level.SEVERE, new Object[]{"Initial state or a state which should be in other partition is not covered by certificate."});
                bl = false;
                return bl;
            }
            this.logger.log(Level.INFO, new Object[]{"Check property."});
            this.stats.getPropertyCheckingTimer().start();
            try {
                if (!this.cpa.getPropChecker().satisfiesProperty(certificate)) {
                    this.logger.log(Level.SEVERE, new Object[]{"Property violated"});
                    bl = false;
                    return bl;
                }
            }
            finally {
                this.stats.getPropertyCheckingTimer().stop();
            }
            bl = true;
            return bl;
        }
        finally {
            executor.shutdown();
        }
    }

    @Override
    protected void writeProofToStream(ObjectOutputStream pOut, UnmodifiableReachedSet pReached, ConfigurableProgramAnalysis pCpa) throws IOException, InvalidConfigurationException, InterruptedException {
        Pair<PartialReachedSetDirectedGraph, List<Set<Integer>>> partitioning = this.ioHelper.computePartialReachedSetAndPartition(pReached, pCpa);
        this.ioHelper.writeMetadata(pOut, pReached.size(), partitioning.getSecond().size());
        for (Set<Integer> partition : partitioning.getSecond()) {
            this.ioHelper.writePartition(pOut, partition, partitioning.getFirst());
        }
    }

    @Override
    protected void readProofFromStream(ObjectInputStream pIn) throws ClassNotFoundException, InvalidConfigurationException, IOException {
        this.ioHelper.readMetadata(pIn, true);
    }

    @Override
    public Collection<Statistics> getAdditionalProofGenerationStatistics() {
        ArrayList<Statistics> result = new ArrayList<Statistics>(super.getAdditionalProofGenerationStatistics());
        result.add(this.ioHelper.getGraphStatistic());
        return result;
    }

    private class PartitionReader
    implements Runnable {
        private final AtomicBoolean checkResult;
        private final Semaphore partitionsRead;
        private final Semaphore checkedPartitions;

        public PartitionReader(AtomicBoolean pCheckResult, Semaphore pPartitionsRead, Semaphore pCheckedPartitions) {
            this.checkResult = pCheckResult;
            this.partitionsRead = pPartitionsRead;
            this.checkedPartitions = pCheckedPartitions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Triple streams = null;
            try {
                streams = PartialReachedSetIOCheckingInterleavedStrategy.this.openProofStream();
                ObjectInputStream o = (ObjectInputStream)streams.getThird();
                PartialReachedSetIOCheckingInterleavedStrategy.this.ioHelper.readMetadata(o, false);
                for (int i = 0; i < PartialReachedSetIOCheckingInterleavedStrategy.this.ioHelper.getNumPartitions() && this.checkResult.get(); ++i) {
                    PartialReachedSetIOCheckingInterleavedStrategy.this.ioHelper.readPartition(o, PartialReachedSetIOCheckingInterleavedStrategy.this.stats);
                    if (PartialReachedSetIOCheckingInterleavedStrategy.this.shutdownNotifier.shouldShutdown()) {
                        this.abort();
                        break;
                    }
                    this.partitionsRead.release();
                }
            }
            catch (IOException | ClassNotFoundException e) {
                PartialReachedSetIOCheckingInterleavedStrategy.this.logger.logUserException(Level.SEVERE, (Throwable)e, "Partition reading failed. Stop checking");
                this.abort();
            }
            catch (Exception e2) {
                PartialReachedSetIOCheckingInterleavedStrategy.this.logger.logException(Level.SEVERE, (Throwable)e2, "Unexpected failure during proof reading");
                this.abort();
            }
            finally {
                if (streams != null) {
                    try {
                        ((ObjectInputStream)streams.getThird()).close();
                        ((ZipInputStream)streams.getSecond()).close();
                        ((InputStream)streams.getFirst()).close();
                    }
                    catch (IOException e) {
                        throw new AssertionError((Object)e);
                    }
                }
            }
        }

        private void abort() {
            this.checkResult.set(false);
            this.partitionsRead.release(PartialReachedSetIOCheckingInterleavedStrategy.this.ioHelper.getNumPartitions());
            this.checkedPartitions.release(PartialReachedSetIOCheckingInterleavedStrategy.this.ioHelper.getNumPartitions());
        }
    }
}

