/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.parallel.interleaved;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.zip.ZipInputStream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.reachedset.HistoryForwardingReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSetFactory;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.PropertyChecker.PropertyCheckerCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.pcc.strategy.AbstractStrategy;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.CMCPartitionChecker;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.CMCPartitioningIOHelper;
import org.sosy_lab.cpachecker.pcc.strategy.util.cmc.AssumptionAutomatonGenerator;
import org.sosy_lab.cpachecker.pcc.strategy.util.cmc.PartialCPABuilder;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.Triple;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;

public class PartialReachedSetIOCheckingOnlyInterleavedCMCStrategy
extends AbstractStrategy {
    private final Configuration config;
    private final ShutdownNotifier shutdown;
    private final PartialCPABuilder cpaBuilder;
    private final AssumptionAutomatonGenerator automatonWriter;
    private int numProofs;

    public PartialReachedSetIOCheckingOnlyInterleavedCMCStrategy(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Path pProofFile, @Nullable CFA pCFA, @Nullable Specification pSpecification) throws InvalidConfigurationException {
        super(pConfig, pLogger, pProofFile);
        this.cpaBuilder = new PartialCPABuilder(pConfig, pLogger, pShutdownNotifier, pCFA, pSpecification);
        this.automatonWriter = new AssumptionAutomatonGenerator(pConfig, pLogger);
        this.config = pConfig;
        this.logger = pLogger;
        this.shutdown = pShutdownNotifier;
    }

    @Override
    public void constructInternalProofRepresentation(UnmodifiableReachedSet pReached, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException, InterruptedException {
        throw new InvalidConfigurationException("Interleaved proof reading and checking strategies do not  support internal PCC with result check algorithm");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkCertificate(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        pReachedSet.popFromWaitlist();
        if (this.numProofs <= 0) {
            this.logger.log(Level.SEVERE, new Object[]{"No proofs provided."});
            return false;
        }
        try {
            PropertyCheckerCPA[] cpas = new PropertyCheckerCPA[this.numProofs];
            CMCPartitioningIOHelper[] ioHelpers = new CMCPartitioningIOHelper[this.numProofs];
            AbstractState[] roots = new AbstractState[this.numProofs];
            AtomicBoolean checkResult = new AtomicBoolean(true);
            Semaphore partitionsAvailable = new Semaphore(0);
            Semaphore automatonAvailable = new Semaphore(1);
            Thread readingThread = new Thread(new ProofPartReader(automatonAvailable, partitionsAvailable, checkResult, ioHelpers, cpas, roots, new ReachedSetFactory(this.config, this.logger)));
            try {
                readingThread.start();
                int i = 0;
                while (checkResult.get() && i < this.numProofs) {
                    boolean bl;
                    this.shutdown.shutdownIfNecessary();
                    partitionsAvailable.acquire();
                    if (!checkResult.get()) {
                        bl = false;
                        return bl;
                    }
                    CMCPartitionChecker checker = new CMCPartitionChecker(cpas[i], checkResult, this.shutdown, this.logger, roots[i]);
                    for (int j = 0; j < ioHelpers[i].getNumPartitions() && checkResult.get(); ++j) {
                        this.shutdown.shutdownIfNecessary();
                        partitionsAvailable.acquire();
                        if (!checkResult.get()) {
                            boolean bl2 = false;
                            return bl2;
                        }
                        checker.checkPartition(ioHelpers[i].getPartition(j).getFirst(), ioHelpers[i].getPartition(j).getSecond(), ioHelpers[i].getEdgesForPartition(j), ioHelpers[i].getSavedReachedSetSize());
                    }
                    if (!checker.checkCoverageOfExternalsAndInitialState()) {
                        this.logger.log(Level.SEVERE, new Object[]{"Elements which should be checked in different partition are not checked or initial state not covered"});
                        bl = false;
                        return bl;
                    }
                    if (!cpas[i].getPropChecker().satisfiesProperty(checker.getInspectedStates())) {
                        this.logger.log(Level.SEVERE, new Object[]{"Property violation in certificate found."});
                        bl = false;
                        return bl;
                    }
                    Pair<ARGState, List<ARGState>> checkingResult = checker.getAutomatonReconstructionInfo();
                    if (++i < this.numProofs) {
                        this.automatonWriter.writeAutomaton(checkingResult.getFirst(), checkingResult.getSecond());
                        automatonAvailable.release();
                        continue;
                    }
                    if (checkingResult.getSecond().isEmpty()) continue;
                    bl = false;
                    return bl;
                }
                boolean bl = checkResult.get();
                return bl;
            }
            finally {
                checkResult.set(false);
                readingThread.interrupt();
            }
        }
        catch (InvalidConfigurationException e) {
            this.logger.log(Level.SEVERE, new Object[]{"Cannot set up infrastructure for proof checking."});
            return false;
        }
    }

    @Override
    protected void writeProofToStream(ObjectOutputStream pOut, UnmodifiableReachedSet pReached, ConfigurableProgramAnalysis pCpa) throws IOException, InvalidConfigurationException, InterruptedException {
        if (!(pReached instanceof HistoryForwardingReachedSet)) {
            throw new InvalidConfigurationException("Reached sets used by restart algorithm are not memorized. Please enable option analysis.memorizeReachedAfterRestart");
        }
        List<ReachedSet> partialReachedSets = ((HistoryForwardingReachedSet)pReached).getAllReachedSetsUsedAsDelegates();
        if (partialReachedSets == null || partialReachedSets.isEmpty()) {
            this.logger.log(Level.SEVERE, new Object[]{"No proof parts available. Proof cannot be generated."});
            return;
        }
        List<ConfigurableProgramAnalysis> cpas = ((HistoryForwardingReachedSet)pReached).getCPAs();
        if (partialReachedSets.size() != cpas.size()) {
            this.logger.log(Level.SEVERE, new Object[]{"Analysis inconsistent. Proof cannot be generated."});
            return;
        }
        this.logger.log(Level.FINEST, new Object[]{"Write number of proof parts to proof"});
        pOut.writeInt(partialReachedSets.size());
        try {
            for (int i = 0; i < partialReachedSets.size(); ++i) {
                GlobalInfo.getInstance().setUpInfoFromCPA(cpas.get(i));
                ReachedSet reached = partialReachedSets.get(i);
                HashSet unexplored = Sets.newHashSetWithExpectedSize((int)reached.getWaitlist().size());
                for (AbstractState toExplore : reached.getWaitlist()) {
                    unexplored.add((ARGState)toExplore);
                }
                CMCPartitioningIOHelper ioHelper = new CMCPartitioningIOHelper(this.config, this.logger, this.shutdown, this.automatonWriter.getAllAncestorsFor(unexplored), unexplored, (ARGState)reached.getFirstState());
                ioHelper.writeProof(pOut, reached, pCpa);
            }
        }
        catch (ClassCastException e) {
            this.logger.logDebugException((Throwable)e);
            this.logger.log(Level.SEVERE, new Object[]{"Stop writing proof. Not all analysis use ARG CPA as top level CPA"});
        }
    }

    @Override
    protected void readProofFromStream(ObjectInputStream pIn) throws ClassNotFoundException, InvalidConfigurationException, IOException {
        this.numProofs = pIn.readInt();
    }

    private class ProofPartReader
    implements Runnable {
        private final AtomicBoolean checkResult;
        private final Semaphore mainSemaphore;
        private final Semaphore startReading;
        private final CMCPartitioningIOHelper[] ioHelperPerProofPart;
        private final PropertyCheckerCPA[] cpas;
        private final AbstractState[] roots;
        private final ReachedSetFactory factory;

        public ProofPartReader(Semaphore pReadNext, Semaphore pPartitionsAvailable, AtomicBoolean pCheckResult, CMCPartitioningIOHelper[] pIoHelpers, PropertyCheckerCPA[] pCpas, AbstractState[] pRoots, ReachedSetFactory pFactory) {
            this.startReading = pReadNext;
            this.checkResult = pCheckResult;
            this.mainSemaphore = pPartitionsAvailable;
            this.ioHelperPerProofPart = pIoHelpers;
            this.cpas = pCpas;
            this.roots = pRoots;
            this.factory = pFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Triple streams = null;
            try {
                streams = PartialReachedSetIOCheckingOnlyInterleavedCMCStrategy.this.openProofStream();
                ObjectInputStream o = (ObjectInputStream)streams.getThird();
                o.readInt();
                for (int i = 0; i < PartialReachedSetIOCheckingOnlyInterleavedCMCStrategy.this.numProofs && this.checkResult.get(); ++i) {
                    CMCPartitioningIOHelper ioHelper;
                    this.startReading.acquire();
                    this.ioHelperPerProofPart[i] = ioHelper = new CMCPartitioningIOHelper(PartialReachedSetIOCheckingOnlyInterleavedCMCStrategy.this.config, PartialReachedSetIOCheckingOnlyInterleavedCMCStrategy.this.logger, PartialReachedSetIOCheckingOnlyInterleavedCMCStrategy.this.shutdown);
                    ConfigurableProgramAnalysis cpa = PartialReachedSetIOCheckingOnlyInterleavedCMCStrategy.this.cpaBuilder.buildPartialCPA(i, this.factory);
                    if (!(cpa instanceof PropertyCheckerCPA)) {
                        PartialReachedSetIOCheckingOnlyInterleavedCMCStrategy.this.logger.log(Level.SEVERE, new Object[]{"Conflicting configuration: Partial proofs must be checked with CPA based strategy but toplevel CPA is not a PropertyCheckerCPA as needed"});
                        this.abortPreparation();
                        break;
                    }
                    this.cpas[i] = (PropertyCheckerCPA)cpa;
                    GlobalInfo.getInstance().setUpInfoFromCPA(this.cpas[i]);
                    boolean mustReadAndCheckSequentially = CPAs.retrieveCPA(cpa, PredicateCPA.class) != null;
                    ioHelper.readMetadata(o, true);
                    this.roots[i] = ioHelper.getRoot();
                    if (this.roots[i] == null) {
                        PartialReachedSetIOCheckingOnlyInterleavedCMCStrategy.this.logger.log(Level.SEVERE, new Object[]{"Root node not well specified in proof."});
                        this.abortPreparation();
                        break;
                    }
                    if (!mustReadAndCheckSequentially) {
                        this.mainSemaphore.release();
                    }
                    for (int j = 0; j < ioHelper.getNumPartitions() && this.checkResult.get(); ++j) {
                        ioHelper.readPartition(o, PartialReachedSetIOCheckingOnlyInterleavedCMCStrategy.this.stats);
                        if (PartialReachedSetIOCheckingOnlyInterleavedCMCStrategy.this.shutdown.shouldShutdown()) {
                            this.abortPreparation();
                            break;
                        }
                        if (mustReadAndCheckSequentially) continue;
                        this.mainSemaphore.release();
                    }
                    if (!mustReadAndCheckSequentially) continue;
                    this.mainSemaphore.release(ioHelper.getNumPartitions() + 1);
                }
            }
            catch (IOException | ClassNotFoundException e) {
                PartialReachedSetIOCheckingOnlyInterleavedCMCStrategy.this.logger.logUserException(Level.SEVERE, (Throwable)e, "Partition reading failed. Stop checking");
                this.abortPreparation();
            }
            catch (InterruptedException exp) {
                if (this.checkResult.get()) {
                    PartialReachedSetIOCheckingOnlyInterleavedCMCStrategy.this.logger.log(Level.SEVERE, new Object[]{"Unexpected interrupt. Stop checking."});
                    this.abortPreparation();
                }
            }
            catch (Exception e2) {
                PartialReachedSetIOCheckingOnlyInterleavedCMCStrategy.this.logger.logException(Level.SEVERE, (Throwable)e2, "Unexpected failure during proof reading");
                this.abortPreparation();
            }
            finally {
                if (streams != null) {
                    try {
                        ((ObjectInputStream)streams.getThird()).close();
                        ((ZipInputStream)streams.getSecond()).close();
                        ((InputStream)streams.getFirst()).close();
                    }
                    catch (IOException e) {
                        throw new AssertionError((Object)e);
                    }
                }
            }
        }

        private void abortPreparation() {
            this.checkResult.set(false);
            this.mainSemaphore.release(2);
        }
    }
}

