/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.parallel.interleaved;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.PropertyChecker.PropertyCheckerCPA;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.pcc.strategy.AbstractStrategy;
import org.sosy_lab.cpachecker.pcc.strategy.parallel.ParallelPartitionChecker;
import org.sosy_lab.cpachecker.pcc.strategy.parallel.io.ParallelPartitionReader;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.PartitioningIOHelper;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.PartitioningUtils;

@Options(prefix="pcc.interleaved")
public class PartialReachedSetParallelIOCheckingInterleavedStrategy
extends AbstractStrategy {
    @Option(secure=true, name="useReadCores", description="The number of cores used exclusively for proof reading. Must be less than pcc.useCores and may not be negative. Value 0 means that the cores used for reading and checking are shared")
    private int numReadThreads = 0;
    private int nextPartition;
    private final PartitioningIOHelper ioHelper;
    private final ShutdownNotifier shutdown;
    private final PropertyCheckerCPA cpa;

    public PartialReachedSetParallelIOCheckingInterleavedStrategy(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, Path pProofFile, @Nullable PropertyCheckerCPA pCpa) throws InvalidConfigurationException {
        super(pConfig, pLogger, pProofFile);
        pConfig.inject((Object)this);
        this.shutdown = pShutdownNotifier;
        this.cpa = pCpa;
        this.ioHelper = new PartitioningIOHelper(pConfig, pLogger, pShutdownNotifier);
        this.numReadThreads = Math.min(this.numReadThreads, this.numThreads - 1);
        this.numReadThreads = Math.max(0, this.numReadThreads);
        this.addPCCStatistic(this.ioHelper.getPartitioningStatistc());
    }

    @Override
    public void constructInternalProofRepresentation(UnmodifiableReachedSet pReached, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        throw new InvalidConfigurationException("Interleaved proof reading and checking strategies do not  support internal PCC with result check algorithm");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkCertificate(ReachedSet pReachedSet) throws CPAException, InterruptedException {
        AtomicBoolean checkResult = new AtomicBoolean(true);
        Semaphore partitionChecked = new Semaphore(0);
        Semaphore partitionsRead = new Semaphore(0);
        HashSet certificate = Sets.newHashSetWithExpectedSize((int)this.ioHelper.getNumPartitions());
        HashMultimap partitionNodes = HashMultimap.create();
        ArrayList<AbstractState> inOtherPartition = new ArrayList<AbstractState>();
        AbstractState initialState = pReachedSet.popFromWaitlist();
        Precision initPrec = pReachedSet.getPrecision(initialState);
        ReentrantLock lock = new ReentrantLock();
        ExecutorService executor = null;
        ExecutorService readExecutor = null;
        ExecutorService checkExecutor = null;
        this.logger.log(Level.INFO, new Object[]{"Create and start threads"});
        try {
            if (this.numReadThreads == 0) {
                executor = Executors.newFixedThreadPool(this.numThreads);
                this.startReadingThreads(this.numThreads, executor, checkResult, partitionsRead);
                this.startCheckingThreads(this.numThreads, executor, checkResult, partitionsRead, partitionChecked, certificate, (Multimap<CFANode, AbstractState>)partitionNodes, inOtherPartition, initPrec, lock);
            } else {
                readExecutor = Executors.newFixedThreadPool(this.numReadThreads);
                this.startReadingThreads(this.numReadThreads, readExecutor, checkResult, partitionsRead);
                checkExecutor = Executors.newFixedThreadPool(this.numThreads - this.numReadThreads);
                this.startCheckingThreads(this.numThreads - this.numReadThreads, checkExecutor, checkResult, partitionsRead, partitionChecked, certificate, (Multimap<CFANode, AbstractState>)partitionNodes, inOtherPartition, initPrec, lock);
            }
            partitionChecked.acquire(this.ioHelper.getNumPartitions());
            if (!checkResult.get()) {
                boolean bl = false;
                return bl;
            }
            this.logger.log(Level.INFO, new Object[]{"Add initial state to elements for which it will be checked if they are covered by partition nodes of certificate."});
            inOtherPartition.add(initialState);
            this.logger.log(Level.INFO, new Object[]{"Check if initial state and all nodes which should be contained in different partition are covered by certificate (partition node)."});
            if (!PartitioningUtils.areElementsCoveredByPartitionElement(inOtherPartition, (Multimap<CFANode, AbstractState>)partitionNodes, this.cpa.getStopOperator(), initPrec)) {
                this.logger.log(Level.SEVERE, new Object[]{"Initial state or a state which should be in other partition is not covered by certificate."});
                boolean bl = false;
                return bl;
            }
            this.logger.log(Level.INFO, new Object[]{"Check property."});
            this.stats.getPropertyCheckingTimer().start();
            try {
                if (!this.cpa.getPropChecker().satisfiesProperty(certificate)) {
                    this.logger.log(Level.SEVERE, new Object[]{"Property violated"});
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.stats.getPropertyCheckingTimer().stop();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
            if (readExecutor != null) {
                readExecutor.shutdown();
            }
            if (checkExecutor != null) {
                checkExecutor.shutdown();
            }
        }
    }

    private void startReadingThreads(int threads, ExecutorService pReadingExecutor, AtomicBoolean pCheckResult, Semaphore partitionsRead) {
        AtomicInteger nextPartitionId = new AtomicInteger(0);
        for (int i = 0; i < threads; ++i) {
            pReadingExecutor.execute(new ParallelPartitionReader(pCheckResult, partitionsRead, nextPartitionId, this, this.ioHelper, this.stats, this.logger));
        }
    }

    private void startCheckingThreads(int threads, ExecutorService pCheckingExecutor, AtomicBoolean pCheckResult, Semaphore pPartitionsRead, Semaphore pPartitionChecked, Collection<AbstractState> pCertificate, Multimap<CFANode, AbstractState> pInPartition, Collection<AbstractState> pInOtherPartition, Precision pInitialPrecision, Lock pLock) {
        AtomicInteger availablePartitions = new AtomicInteger(0);
        AtomicInteger nextId = new AtomicInteger(0);
        for (int i = 0; i < threads; ++i) {
            pCheckingExecutor.execute(new ParallelPartitionChecker(availablePartitions, nextId, pCheckResult, pPartitionsRead, pPartitionChecked, pLock, this.ioHelper, pInPartition, pCertificate, pInOtherPartition, pInitialPrecision, this.cpa.getStopOperator(), this.cpa.getTransferRelation(), this.shutdown, this.logger));
        }
    }

    @Override
    protected void writeProofToStream(ObjectOutputStream pOut, UnmodifiableReachedSet pReached, ConfigurableProgramAnalysis pCpa) throws IOException, InvalidConfigurationException, InterruptedException {
        this.ioHelper.constructInternalProofRepresentation(pReached, pCpa);
        this.ioHelper.writeMetadata(pOut, pReached.size(), this.ioHelper.getNumPartitions());
        this.nextPartition = 0;
    }

    @Override
    protected boolean writeAdditionalProofStream(ObjectOutputStream pOut) throws IOException {
        this.ioHelper.writePartition(pOut, this.ioHelper.getPartition(this.nextPartition));
        ++this.nextPartition;
        return this.nextPartition < this.ioHelper.getNumPartitions();
    }

    @Override
    protected void readProofFromStream(ObjectInputStream pIn) throws ClassNotFoundException, InvalidConfigurationException, IOException {
        this.ioHelper.readMetadata(pIn, true);
    }

    @Override
    public Collection<Statistics> getAdditionalProofGenerationStatistics() {
        ArrayList<Statistics> result = new ArrayList<Statistics>(super.getAdditionalProofGenerationStatistics());
        result.add(this.ioHelper.getGraphStatistic());
        return result;
    }
}

