/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partialcertificate;

import java.util.ArrayDeque;
import java.util.HashSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;

public abstract class AbstractARGPass {
    private final boolean visitMultipleTimes;

    protected AbstractARGPass(boolean pMultipleVisits) {
        this.visitMultipleTimes = pMultipleVisits;
    }

    public void passARG(ARGState root) {
        HashSet<ARGState> seen = new HashSet<ARGState>();
        ArrayDeque<ARGState> toVisit = new ArrayDeque<ARGState>();
        toVisit.add(root);
        seen.add(root);
        while (!toVisit.isEmpty()) {
            ARGState currentNode = (ARGState)toVisit.pollLast();
            this.visitARGNode(currentNode);
            if (this.stopPathDiscovery(currentNode)) continue;
            for (ARGState child : currentNode.getChildren()) {
                boolean childKnown = seen.contains(child);
                if (!childKnown) {
                    toVisit.addLast(child);
                    seen.add(child);
                }
                if (!this.visitMultipleTimes || !childKnown) continue;
                this.visitARGNode(child);
            }
        }
    }

    public abstract void visitARGNode(ARGState var1);

    public abstract boolean stopPathDiscovery(ARGState var1);
}

