/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partialcertificate;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.pcc.PartialReachedConstructionAlgorithm;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.ARGBasedPartialReachedSetConstructionAlgorithm;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.AbstractARGPass;
import org.sosy_lab.cpachecker.util.CPAs;

public class MonotoneTransferFunctionARGBasedPartialReachedSetConstructionAlgorithm
implements PartialReachedConstructionAlgorithm {
    private final boolean returnARGStates;
    private final boolean withCMC;

    public MonotoneTransferFunctionARGBasedPartialReachedSetConstructionAlgorithm(boolean pReturnARGStatesInsteadOfWrappedStates, boolean pWithCMC) {
        this.returnARGStates = pReturnARGStatesInsteadOfWrappedStates;
        this.withCMC = pWithCMC;
    }

    @Override
    public AbstractState[] computePartialReachedSet(UnmodifiableReachedSet pReached, ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        if (!(pReached.getFirstState() instanceof ARGState)) {
            throw new InvalidConfigurationException("May only compute partial reached set with this algorithm if an ARG is constructed and ARG is top level state.");
        }
        ARGCPA argCpa = CPAs.retrieveCPAOrFail(pCpa, ARGCPA.class, ARGBasedPartialReachedSetConstructionAlgorithm.class);
        ARGState root = (ARGState)pReached.getFirstState();
        NodeSelectionARGPass argPass = this.getARGPass(pReached.getPrecision(root), root, argCpa);
        argPass.passARG(root);
        List<? extends AbstractState> reachedSetSubset = argPass.getSelectedNodes();
        return reachedSetSubset.toArray(new AbstractState[0]);
    }

    protected NodeSelectionARGPass getARGPass(Precision pRootPrecision, ARGState pRoot, ARGCPA pCpa) throws InvalidConfigurationException {
        return new NodeSelectionARGPass(pRoot);
    }

    protected class NodeSelectionARGPass
    extends AbstractARGPass {
        private final ARGState root;
        private List<AbstractState> wrappedARGStates;
        private List<ARGState> argStates;

        public NodeSelectionARGPass(ARGState pRoot) {
            super(false);
            this.wrappedARGStates = new ArrayList<AbstractState>();
            this.argStates = new ArrayList<ARGState>();
            this.root = pRoot;
        }

        @Override
        public void visitARGNode(ARGState pNode) {
            if (this.isToAdd(pNode)) {
                if (MonotoneTransferFunctionARGBasedPartialReachedSetConstructionAlgorithm.this.returnARGStates) {
                    this.argStates.add(pNode);
                } else {
                    this.wrappedARGStates.add(pNode.getWrappedState());
                }
            }
        }

        protected boolean isToAdd(ARGState pNode) {
            return Objects.equals(pNode, this.root) || pNode.getParents().size() > 1 || !pNode.getCoveredByThis().isEmpty() && !pNode.isCovered() || MonotoneTransferFunctionARGBasedPartialReachedSetConstructionAlgorithm.this.withCMC && (pNode.getChildren().size() > 1 || !pNode.isCovered() && (pNode.getChildren().isEmpty() || pNode.getParents().iterator().next().getChildren().size() > 1));
        }

        @Override
        public boolean stopPathDiscovery(ARGState pNode) {
            return false;
        }

        public List<? extends AbstractState> getSelectedNodes() {
            if (MonotoneTransferFunctionARGBasedPartialReachedSetConstructionAlgorithm.this.returnARGStates) {
                return this.argStates;
            }
            return this.wrappedARGStates;
        }
    }
}

