/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partialcertificate;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.AbstractARGPass;
import org.sosy_lab.cpachecker.util.Pair;

public class PartialReachedSetDirectedGraph
implements Statistics {
    private final AbstractState[] nodes;
    private final int numNodes;
    private final ImmutableList<ImmutableList<Integer>> adjacencyList;

    public PartialReachedSetDirectedGraph(ARGState[] pNodes) {
        if (pNodes == null) {
            this.nodes = new AbstractState[0];
            this.numNodes = 0;
            this.adjacencyList = ImmutableList.of();
        } else {
            this.nodes = (AbstractState[])pNodes.clone();
            this.numNodes = this.nodes.length;
            this.adjacencyList = PartialReachedSetDirectedGraph.buildAdjacencyList(pNodes);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static ImmutableList<ImmutableList<Integer>> buildAdjacencyList(ARGState[] pNodes) {
        void var5_9;
        ArrayList<List<Integer>> adjacencyList = new ArrayList<List<Integer>>(pNodes.length);
        for (ARGState aRGState : pNodes) {
            adjacencyList.add(new ArrayList());
        }
        SuccessorEdgeConstructor edgeConstructor = new SuccessorEdgeConstructor(pNodes, adjacencyList);
        ARGState[] aRGStateArray = pNodes;
        int n = aRGStateArray.length;
        boolean bl = false;
        while (var5_9 < n) {
            ARGState node = aRGStateArray[var5_9];
            edgeConstructor.setPredecessorBeforeARGPass(node);
            edgeConstructor.passARG(node);
            ++var5_9;
        }
        ArrayList<ImmutableList> newList = new ArrayList<ImmutableList>(adjacencyList.size());
        for (List list : adjacencyList) {
            newList.add(ImmutableList.copyOf((Collection)list));
        }
        return ImmutableList.copyOf(newList);
    }

    public Set<Integer> getPredecessorsOf(int node) {
        HashSet<Integer> ret = new HashSet<Integer>();
        for (int i = 0; i < this.getNumNodes(); ++i) {
            if (i == node || !((ImmutableList)this.getAdjacencyList().get(i)).contains((Object)node)) continue;
            ret.add(i);
        }
        return ret;
    }

    public int getNumNodes() {
        return this.numNodes;
    }

    public List<AbstractState> getNodes() {
        return ImmutableList.copyOf((Object[])this.nodes);
    }

    public AbstractState getNode(int nodeIndex) {
        Preconditions.checkArgument((nodeIndex >= 0 && nodeIndex < this.numNodes ? 1 : 0) != 0);
        return this.nodes[nodeIndex];
    }

    public ImmutableList<ImmutableList<Integer>> getAdjacencyList() {
        return this.adjacencyList;
    }

    public AbstractState[] getSuccessorNodesOutsideSet(Set<Integer> pNodeSetIndices, boolean pAsARGState) {
        CollectingNodeVisitor visitor = new CollectingNodeVisitor(pAsARGState);
        this.visitOutsideSuccessors(pNodeSetIndices, visitor);
        return visitor.setRes.toArray(new AbstractState[0]);
    }

    public long getNumSuccessorNodesOutsideSet(Set<Integer> pNodeSetIndices) {
        CountingNodeVisitor visitor = new CountingNodeVisitor();
        this.visitOutsideSuccessors(pNodeSetIndices, visitor);
        return visitor.numOutside;
    }

    public long getNumEdgesBetween(Set<Integer> pSrcNodeSetIndices, Set<Integer> pDstNodeSetIndices) {
        CountingNodeVisitor visitor = new CountingNodeVisitor();
        this.visitOutsideAdjacentNodes(pSrcNodeSetIndices, pDstNodeSetIndices, visitor);
        return visitor.numOutside;
    }

    public long getNumEdgesBetween(Integer pSrcNodeIndex, Set<Integer> pDstNodeSetIndices) {
        return this.getNumEdgesBetween(Sets.newHashSet((Object[])new Integer[]{pSrcNodeIndex}), pDstNodeSetIndices);
    }

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"}, justification="rethrown as other type")
    public AbstractState[] getSetNodes(Set<Integer> pNodeSetIndices, boolean pAsARGState) {
        ArrayList<AbstractState> listRes = new ArrayList<AbstractState>();
        try {
            for (Integer node : pNodeSetIndices) {
                if (pAsARGState) {
                    listRes.add(this.nodes[node]);
                    continue;
                }
                listRes.add(((ARGState)this.nodes[node]).getWrappedState());
            }
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            throw new IllegalArgumentException("Wrong index set must not be null and all indices must be within [0;" + this.numNodes + "-1].", e);
        }
        return listRes.toArray(new AbstractState[0]);
    }

    @Override
    public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        int edges = 0;
        int maxin = 0;
        int minin = Integer.MAX_VALUE;
        int maxout = 0;
        int minout = Integer.MAX_VALUE;
        double avgin = 0.0;
        double avgout = 0.0;
        int MAX_DEG = 10;
        int[] inDistribution = new int[10];
        double[] normalIn = new double[10];
        int[] outDistribution = new int[10];
        double[] normalOut = new double[10];
        int[] indegrees = new int[this.nodes.length];
        for (ImmutableList successors : this.adjacencyList) {
            int successorSize = successors.size();
            edges += successors.size();
            if (successorSize >= 10) {
                outDistribution[9] = outDistribution[9] + 1;
            } else {
                int n = successorSize;
                outDistribution[n] = outDistribution[n] + 1;
            }
            maxout = Math.max(maxout, successorSize);
            minout = Math.min(minout, successorSize);
            avgout += (double)successorSize;
            for (Integer succ : successors) {
                indegrees[succ.intValue()] = indegrees[succ] + 1;
            }
        }
        if (this.nodes.length > 0) {
            for (int a = 0; a < outDistribution.length; ++a) {
                normalOut[a] = (double)outDistribution[a] / (double)this.nodes.length;
            }
            Arrays.sort(indegrees);
            minin = indegrees[0];
            maxin = indegrees[indegrees.length - 1];
            for (int indegree : indegrees) {
                avgin += (double)indegree;
                if (indegree >= 10) {
                    inDistribution[9] = inDistribution[9] + 1;
                    continue;
                }
                int n = indegree;
                inDistribution[n] = inDistribution[n] + 1;
            }
            avgin /= (double)this.nodes.length;
            avgout /= (double)this.nodes.length;
            for (int a = 0; a < inDistribution.length; ++a) {
                normalIn[a] = (double)inDistribution[a] / (double)this.nodes.length;
            }
        } else {
            minin = 0;
            minout = 0;
        }
        pOut.println("#nodes:         " + this.nodes.length);
        pOut.println("#edges:         " + edges);
        pOut.println("max indegree:   " + maxin);
        pOut.println("min indegree:   " + minin);
        pOut.println("in distribution:   " + Arrays.toString(inDistribution));
        pOut.println("relative in distr:   " + Arrays.toString(normalIn));
        pOut.printf("avg. indegree:  %.2f%n", avgin);
        pOut.println("max outdegree:  " + maxout);
        pOut.println("min outdegree:  " + minout);
        pOut.println("out distribution:   " + Arrays.toString(outDistribution));
        pOut.println("relative out distr:   " + Arrays.toString(normalOut));
        pOut.printf("avg. outdegree: %.2f%n", avgout);
    }

    @Override
    public @Nullable String getName() {
        return null;
    }

    private void visitOutsideSuccessorsOf(int pPredecessor, NodeVisitor pVisitor, Predicate<Integer> pMustVisit) {
        for (Integer successor : (ImmutableList)this.adjacencyList.get(pPredecessor)) {
            if (!pMustVisit.apply((Object)successor)) continue;
            pVisitor.visit(successor);
        }
    }

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"}, justification="rethrown as other type")
    private void visitOutsideSuccessors(Set<Integer> pNodeSet, NodeVisitor pVisitor) {
        try {
            Predicate isOutsideSet = pNode -> !pNodeSet.contains(pNode);
            for (int predecessor : pNodeSet) {
                this.visitOutsideSuccessorsOf(predecessor, pVisitor, (Predicate<Integer>)isOutsideSet);
            }
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            throw new IllegalArgumentException("Wrong index set must not be null and all indices be within [0;" + this.numNodes + "-1].", e);
        }
    }

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"}, justification="rethrown as other type")
    private void visitOutsideAdjacentNodes(Set<Integer> pSrcNodeSetIndices, Set<Integer> pDstNodeSetIndices, NodeVisitor pVisitor) {
        try {
            this.visitSuccessorsInOtherSet(pSrcNodeSetIndices, pDstNodeSetIndices, pVisitor);
            this.visitSuccessorsInOtherSet(pDstNodeSetIndices, pSrcNodeSetIndices, pVisitor);
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            throw new IllegalArgumentException("Wrong index set must not be null and all indices be within [0;" + this.numNodes + "-1].", e);
        }
    }

    private void visitSuccessorsInOtherSet(Set<Integer> pNodeSet, Set<Integer> pOtherNodeSet, NodeVisitor pVisitor) {
        Predicate isInOtherSet = pOtherNodeSet::contains;
        for (int predecessor : pNodeSet) {
            this.visitOutsideSuccessorsOf(predecessor, pVisitor, (Predicate<Integer>)isInOtherSet);
        }
    }

    private static class SuccessorEdgeConstructor
    extends AbstractARGPass {
        private ARGState predecessor;
        private int indexPredecessor;
        private final Map<AbstractState, Integer> nodeToIndex = new HashMap<AbstractState, Integer>();
        private final List<List<Integer>> changeableAdjacencyList;
        private final Set<Pair<Integer, Integer>> knownEdges;

        public SuccessorEdgeConstructor(ARGState[] pNodes, List<List<Integer>> pAdjacencyList) {
            super(false);
            for (int i = 0; i < pNodes.length; ++i) {
                this.nodeToIndex.put(pNodes[i], i);
            }
            this.changeableAdjacencyList = pAdjacencyList;
            this.knownEdges = Sets.newHashSetWithExpectedSize((int)pNodes.length);
        }

        public void setPredecessorBeforeARGPass(ARGState pNewPredecessor) {
            this.predecessor = pNewPredecessor;
            this.indexPredecessor = this.nodeToIndex.get(this.predecessor);
        }

        @Override
        public void visitARGNode(ARGState pNode) {
            if (this.stopPathDiscovery(pNode)) {
                while (pNode.isCovered()) {
                    pNode = pNode.getCoveringState();
                }
                int indexSuccessor = this.nodeToIndex.get(pNode);
                Pair<Integer, Integer> edge = Pair.of(this.indexPredecessor, indexSuccessor);
                if (this.knownEdges.add(edge)) {
                    this.changeableAdjacencyList.get(this.indexPredecessor).add(indexSuccessor);
                }
            }
        }

        @Override
        public boolean stopPathDiscovery(ARGState pNode) {
            return !Objects.equals(pNode, this.predecessor) && (this.nodeToIndex.containsKey(pNode) || pNode.isCovered());
        }
    }

    private static class CountingNodeVisitor
    implements NodeVisitor {
        private long numOutside = 0L;

        private CountingNodeVisitor() {
        }

        @Override
        public void visit(int pSuccessor) {
            ++this.numOutside;
        }
    }

    private class CollectingNodeVisitor
    implements NodeVisitor {
        private final Set<AbstractState> setRes = new HashSet<AbstractState>();
        private final boolean collectAsARGState;

        public CollectingNodeVisitor(boolean pCollectAsARGState) {
            this.collectAsARGState = pCollectAsARGState;
        }

        @Override
        public void visit(int pSuccessor) {
            if (this.collectAsARGState) {
                this.setRes.add(PartialReachedSetDirectedGraph.this.nodes[pSuccessor]);
            } else {
                this.setRes.add(((ARGState)PartialReachedSetDirectedGraph.this.nodes[pSuccessor]).getWrappedState());
            }
        }
    }

    private static interface NodeVisitor {
        public void visit(int var1);
    }
}

