/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partialcertificate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.PartialReachedSetDirectedGraph;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.WeightedEdge;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.WeightedGraphRandomIterator;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.WeightedNode;

public class WeightedGraph
implements Iterable<WeightedNode> {
    private final int numNodes;
    private int totalNodeWeight;
    private final WeightedNode[] nodes;
    private final Map<Integer, Set<WeightedEdge>> outgoingEdges;
    private final Map<Integer, Set<WeightedEdge>> incomingEdges;

    public WeightedGraph(PartialReachedSetDirectedGraph pGraph) {
        Preconditions.checkArgument((pGraph != null ? 1 : 0) != 0, (Object)"Graph may not be null.");
        this.totalNodeWeight = 0;
        this.numNodes = pGraph.getNumNodes();
        this.nodes = new WeightedNode[this.numNodes];
        this.outgoingEdges = new HashMap<Integer, Set<WeightedEdge>>(this.numNodes);
        this.incomingEdges = new HashMap<Integer, Set<WeightedEdge>>(this.numNodes);
        int weight = 1;
        ImmutableList<ImmutableList<Integer>> adjacencyList = pGraph.getAdjacencyList();
        for (int actualNode = 0; actualNode < this.numNodes; ++actualNode) {
            WeightedNode start = new WeightedNode(actualNode, weight);
            for (Integer successorNode : (ImmutableList)adjacencyList.get(actualNode)) {
                WeightedNode end = new WeightedNode(successorNode, weight);
                WeightedEdge edge = new WeightedEdge(start, end, weight);
                this.addEdge(edge);
            }
            if (this.nodes[actualNode] != null) continue;
            this.nodes[actualNode] = start;
        }
    }

    public WeightedGraph(int pNumNodes) {
        Preconditions.checkArgument((pNumNodes > 0 ? 1 : 0) != 0, (Object)"Graph Size may not be 0.");
        this.numNodes = pNumNodes;
        this.nodes = new WeightedNode[this.numNodes];
        this.outgoingEdges = new HashMap<Integer, Set<WeightedEdge>>(this.numNodes);
        this.incomingEdges = new HashMap<Integer, Set<WeightedEdge>>(this.numNodes);
    }

    public void insertNode(WeightedNode node) {
        int nodeNum = node.getNodeNumber();
        int nodeWeight = node.getWeight();
        if (this.nodes[nodeNum] != null) {
            this.totalNodeWeight -= this.nodes[nodeNum].getWeight();
        }
        this.nodes[nodeNum] = node;
        this.totalNodeWeight += nodeWeight;
    }

    public void addEdge(WeightedEdge edge) {
        WeightedNode start = edge.getStartNode();
        int startNumber = start.getNodeNumber();
        WeightedNode end = edge.getEndNode();
        int endNumber = end.getNodeNumber();
        this.insertNode(start);
        this.insertNode(end);
        boolean edgeExisted = false;
        if (!this.incomingEdges.containsKey(endNumber)) {
            this.incomingEdges.put(endNumber, new HashSet());
        }
        if (!this.outgoingEdges.containsKey(startNumber)) {
            this.outgoingEdges.put(startNumber, new HashSet());
        }
        if (!this.incomingEdges.get(endNumber).isEmpty() && !this.outgoingEdges.get(startNumber).isEmpty()) {
            Set<WeightedEdge> inEdges = this.incomingEdges.get(endNumber);
            for (WeightedEdge inEdge : inEdges) {
                if (inEdge.getStartNode().getNodeNumber() != startNumber) continue;
                inEdge.addWeight(edge.getWeight());
                edgeExisted = true;
                break;
            }
        }
        if (!edgeExisted) {
            this.incomingEdges.get(endNumber).add(edge);
            this.outgoingEdges.get(startNumber).add(edge);
        }
    }

    public void addEdges(Set<WeightedEdge> edges) {
        for (WeightedEdge edge : edges) {
            this.addEdge(edge);
        }
    }

    public Iterable<WeightedNode> randomIterator() {
        return () -> new WeightedGraphRandomIterator(this);
    }

    public @Nullable WeightedNode getNode(int node) {
        return this.nodes[node];
    }

    public Set<WeightedNode> getPredecessors(int node) {
        HashSet<WeightedNode> predecessors = new HashSet<WeightedNode>();
        if (this.incomingEdges.get(node) != null) {
            for (WeightedEdge e : this.incomingEdges.get(node)) {
                predecessors.add(e.getStartNode());
            }
        }
        return predecessors;
    }

    public Set<WeightedNode> getPredecessors(WeightedNode node) {
        return this.getPredecessors(node.getNodeNumber());
    }

    public Set<WeightedNode> getSuccessors(int node) {
        HashSet<WeightedNode> successors = new HashSet<WeightedNode>();
        if (this.outgoingEdges.get(node) != null) {
            for (WeightedEdge e : this.outgoingEdges.get(node)) {
                successors.add(e.getEndNode());
            }
        }
        return successors;
    }

    public Set<WeightedNode> getSuccessors(WeightedNode node) {
        return this.getSuccessors(node.getNodeNumber());
    }

    public Set<Integer> getIntSuccessors(int node) {
        HashSet<Integer> successors = new HashSet<Integer>();
        if (this.outgoingEdges.get(node) != null) {
            for (WeightedEdge e : this.outgoingEdges.get(node)) {
                successors.add(e.getEndNode().getNodeNumber());
            }
        }
        return successors;
    }

    public Set<Integer> getIntSuccessors(WeightedNode node) {
        return this.getIntSuccessors(node.getNodeNumber());
    }

    public Set<WeightedNode> getNeighbors(WeightedNode node) {
        return this.getNeighbors(node.getNodeNumber());
    }

    public Set<WeightedNode> getNeighbors(int node) {
        Set<WeightedNode> neighbors = this.getSuccessors(node);
        neighbors.addAll(this.getPredecessors(node));
        return neighbors;
    }

    public static int computeWeight(Set<WeightedNode> nodes) {
        int weight = 0;
        for (WeightedNode node : nodes) {
            weight += node.getWeight();
        }
        return weight;
    }

    public static int computeWeight(Set<Integer> nodes, WeightedGraph wGraph) {
        int weight = 0;
        for (Integer node : nodes) {
            weight += wGraph.getNode(node).getWeight();
        }
        return weight;
    }

    public int getNumNodes() {
        return this.numNodes;
    }

    public Set<WeightedEdge> getOutgoingEdges(WeightedNode node) {
        return this.getOutgoingEdges(node.getNodeNumber());
    }

    public Set<WeightedEdge> getOutgoingEdges(int node) {
        Set<WeightedEdge> edges = this.outgoingEdges.get(node);
        if (edges != null) {
            return edges;
        }
        return new HashSet<WeightedEdge>(0);
    }

    public Set<WeightedEdge> getIncomingEdges(WeightedNode node) {
        return this.getIncomingEdges(node.getNodeNumber());
    }

    public Set<WeightedEdge> getIncomingEdges(int node) {
        Set<WeightedEdge> edges = this.incomingEdges.get(node);
        if (edges != null) {
            return edges;
        }
        return new HashSet<WeightedEdge>(0);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (int node = 0; node < this.numNodes; ++node) {
            if (this.nodes[node] == null) continue;
            int nodeWeight = this.getNode(node).getWeight();
            s.append(node).append("(W:").append(nodeWeight).append("):");
            for (WeightedEdge edge : this.getOutgoingEdges(node)) {
                s.append("--").append(edge.getWeight()).append("-->");
                s.append(edge.getEndNode().getNodeNumber());
            }
            s.append("|| \t");
        }
        return s.toString();
    }

    public int getTotalNodeWeight() {
        return this.totalNodeWeight;
    }

    @Override
    public Iterator<WeightedNode> iterator() {
        return Iterators.forArray((Object[])this.nodes);
    }

    public int computePartitionLoad(int numPartitions) {
        return this.getTotalNodeWeight() / numPartitions + 1;
    }

    public List<Set<Integer>> getGraphAsOnePartition() {
        ArrayList<Set<Integer>> partitioning = new ArrayList<Set<Integer>>(1);
        HashSet<Integer> partition = new HashSet<Integer>(this.numNodes);
        for (WeightedNode node : this.nodes) {
            partition.add(node.getNodeNumber());
        }
        partitioning.add(partition);
        return partitioning;
    }

    public List<Set<Integer>> getNodesSeperatelyPartitioned(int numPartitions) {
        ArrayList<Set<Integer>> partitioning = new ArrayList<Set<Integer>>(this.numNodes);
        int currentPartition = 0;
        for (WeightedNode node : this.nodes) {
            HashSet<Integer> partition = new HashSet<Integer>(1);
            partition.add(node.getNodeNumber());
            partitioning.add(partition);
            ++currentPartition;
        }
        while (currentPartition < numPartitions) {
            partitioning.add(new HashSet(1));
            ++currentPartition;
        }
        return partitioning;
    }
}

