/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partialcertificate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.WeightedGraph;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.WeightedNode;

public class WeightedGraphRandomIterator
implements Iterator<WeightedNode> {
    private static final Random rnd = new Random(0L);
    private final WeightedGraph wGraph;
    private final int size;
    private int current;
    private final List<Integer> permutation;

    public WeightedGraphRandomIterator(WeightedGraph wGraph) {
        this.wGraph = wGraph;
        this.size = wGraph.getNumNodes();
        this.permutation = WeightedGraphRandomIterator.shuffledIndices(this.size);
        this.current = 0;
    }

    @Override
    public boolean hasNext() {
        return this.current < this.size;
    }

    @Override
    public @Nullable WeightedNode next() {
        int nodeIndex = this.permutation.get(this.current++);
        return this.wGraph.getNode(nodeIndex);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static List<Integer> shuffledIndices(int n) {
        ArrayList<Integer> permutation = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            permutation.add(i);
        }
        Collections.shuffle(permutation, rnd);
        return permutation;
    }
}

