/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partitioning;

import java.util.Set;
import org.sosy_lab.cpachecker.core.interfaces.pcc.BestFirstEvaluationFunction;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.WeightedGraph;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.WeightedNode;

public class BestFirstEvaluationFunctionFactory {
    private BestFirstEvaluationFunctionFactory() {
    }

    public static BestFirstEvaluationFunction createEvaluationFunction(BestFirstEvaluationFunctions function) {
        switch (function) {
            case BREADTH_FIRST: {
                return new BestFirstEvaluationFunction(){

                    @Override
                    public int computePriority(Set<Integer> partition, int priority, WeightedNode node, WeightedGraph wGraph) {
                        return priority + 1;
                    }
                };
            }
            case DEPTH_FIRST: {
                return new BestFirstEvaluationFunction(){

                    @Override
                    public int computePriority(Set<Integer> partition, int priority, WeightedNode node, WeightedGraph wGraph) {
                        return priority - 1;
                    }
                };
            }
        }
        return new BestFirstEvaluationFunction(){

            @Override
            public int computePriority(Set<Integer> partition, int priority, WeightedNode node, WeightedGraph wGraph) {
                Set<Integer> successors = wGraph.getIntSuccessors(node);
                successors.removeAll(partition);
                int gain = node.getWeight();
                return WeightedGraph.computeWeight(successors, wGraph) - gain;
            }
        };
    }

    public static enum BestFirstEvaluationFunctions {
        BREADTH_FIRST("breadth-first"),
        DEPTH_FIRST("depth-first"),
        BEST_IMPROVEMENT_FIRST("best-improvement-first");

        private final String description;

        private BestFirstEvaluationFunctions(String pDescription) {
            this.description = pDescription;
        }

        public String toString() {
            return this.description;
        }
    }
}

