/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.pcc.strategy.partitioning;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.interfaces.pcc.BestFirstEvaluationFunction;
import org.sosy_lab.cpachecker.core.interfaces.pcc.WeightedBalancedGraphPartitioner;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.PartialReachedSetDirectedGraph;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.WeightedGraph;
import org.sosy_lab.cpachecker.pcc.strategy.partialcertificate.WeightedNode;
import org.sosy_lab.cpachecker.pcc.strategy.partitioning.BestFirstEvaluationFunctionFactory;

@Options(prefix="pcc.partitioning.bestfirst")
public class BestFirstWeightedBalancedGraphPartitioner
implements WeightedBalancedGraphPartitioner {
    private final LogManager logger;
    private final BestFirstEvaluationFunction evaluationFunction;
    @Option(secure=true, description="Evaluation function to determine exploration order of best-first-search")
    private BestFirstEvaluationFunctionFactory.BestFirstEvaluationFunctions chosenFunction = BestFirstEvaluationFunctionFactory.BestFirstEvaluationFunctions.BEST_IMPROVEMENT_FIRST;
    @Option(secure=true, description="[Best-first] Balance criterion for pairwise optimization of partitions")
    private double balancePrecision = 1.0;

    public BestFirstWeightedBalancedGraphPartitioner(Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = pLogger;
        this.evaluationFunction = BestFirstEvaluationFunctionFactory.createEvaluationFunction(this.chosenFunction);
    }

    public BestFirstWeightedBalancedGraphPartitioner(Configuration pConfig, LogManager pLogger, BestFirstEvaluationFunctionFactory.BestFirstEvaluationFunctions function) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = pLogger;
        this.chosenFunction = function;
        this.evaluationFunction = BestFirstEvaluationFunctionFactory.createEvaluationFunction(function);
    }

    @Override
    public List<Set<Integer>> computePartitioning(int pNumPartitions, PartialReachedSetDirectedGraph pGraph) throws InterruptedException {
        Preconditions.checkArgument((pNumPartitions > 0 && pGraph != null ? 1 : 0) != 0, (Object)"Partitioniong must contain at least 1 partition. Graph may not be null.");
        WeightedGraph wGraph = new WeightedGraph(pGraph);
        return this.computePartitioning(pNumPartitions, wGraph);
    }

    @Override
    public List<Set<Integer>> computePartitioning(int pNumPartitions, WeightedGraph wGraph) throws InterruptedException {
        Preconditions.checkArgument((pNumPartitions > 0 && wGraph != null ? 1 : 0) != 0, (Object)"Partitioniong must contain at least 1 partition. Graph may not be null.");
        this.logger.log(Level.FINE, new Object[]{String.format("[best-first] Compute %d-partitioning with %.2f balance precision. %s evaluation function. Graph size %d", new Object[]{pNumPartitions, this.balancePrecision, this.chosenFunction, wGraph.getNumNodes()})});
        if (pNumPartitions == 1) {
            return wGraph.getGraphAsOnePartition();
        }
        if (pNumPartitions >= wGraph.getNumNodes()) {
            return wGraph.getNodesSeperatelyPartitioned(pNumPartitions);
        }
        BitSet inPartition = new BitSet(wGraph.getNumNodes());
        PriorityQueue<NodePriority> waitlist = new PriorityQueue<NodePriority>();
        int partitionSize = wGraph.computePartitionLoad(pNumPartitions);
        ArrayList<Set<Integer>> result = new ArrayList<Set<Integer>>(pNumPartitions);
        ArrayList<Integer> partitionWeights = new ArrayList<Integer>(pNumPartitions);
        for (int i = 0; i < pNumPartitions; ++i) {
            result.add(Sets.newHashSetWithExpectedSize((int)partitionSize));
            partitionWeights.add(0);
        }
        int partition = 0;
        int nextUnpartitionedNode = 0;
        while (nextUnpartitionedNode < wGraph.getNumNodes() && nextUnpartitionedNode >= 0) {
            waitlist.add(new NodePriority(wGraph.getNode(nextUnpartitionedNode), nextUnpartitionedNode));
            while (!waitlist.isEmpty()) {
                NodePriority nextChosen = (NodePriority)waitlist.poll();
                WeightedNode nextNode = nextChosen.getNode();
                int priority = nextChosen.getPriority();
                if (inPartition.get(nextNode.getNodeNumber())) continue;
                int nodeWeight = nextNode.getWeight();
                if ((double)((Integer)partitionWeights.get(partition) + nodeWeight) > this.balancePrecision * (double)partitionSize && ++partition >= pNumPartitions) {
                    result.add(Sets.newHashSetWithExpectedSize((int)partitionSize));
                    partitionWeights.add(0);
                }
                ((Set)result.get(partition)).add(nextNode.getNodeNumber());
                partitionWeights.set(partition, (Integer)partitionWeights.get(partition) + nodeWeight);
                inPartition.set(nextNode.getNodeNumber());
                for (WeightedNode succ : wGraph.getSuccessors(nextNode)) {
                    int succPriority = this.evaluationFunction.computePriority((Set)result.get(partition), priority, succ, wGraph);
                    waitlist.offer(new NodePriority(succ, succPriority));
                }
            }
            nextUnpartitionedNode = inPartition.nextClearBit(nextUnpartitionedNode);
        }
        return result;
    }

    private static final class NodePriority
    implements Comparable<NodePriority> {
        private final WeightedNode node;
        private final int priority;

        public WeightedNode getNode() {
            return this.node;
        }

        public int getPriority() {
            return this.priority;
        }

        public NodePriority(WeightedNode pNode, int pPriority) {
            this.node = pNode;
            this.priority = pPriority;
        }

        @Override
        public int compareTo(NodePriority compNode) {
            if (compNode == null) {
                return -1;
            }
            return ComparisonChain.start().compare(this.getPriority(), compNode.getPriority()).compare(compNode.getNode().getNodeNumber(), this.getNode().getNodeNumber()).result();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() == this.getClass()) {
                NodePriority compNode = (NodePriority)obj;
                return this.compareTo(compNode) == 0;
            }
            return false;
        }

        public int hashCode() {
            return this.getPriority() + this.getNode().getNodeNumber();
        }

        public String toString() {
            return this.node + "[Prio:" + this.priority + "]";
        }
    }
}

